"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTabsView = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _constants = require("../constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_settings_view = require("./use_settings_view");
var _use_schedule_view = require("./use_schedule_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/attack_discovery/pages/settings_flyout/hooks/use_tabs_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SETTINGS_TAB_CLASS = 'settingsTab';

// We're hiding the tabs in the flyout to accommodate a late-breaking design change.
// Per a team agreement, the tabs will be refactored out in a future PR.
const hiddenTabsStyles = (0, _react2.css)`
  &.${SETTINGS_TAB_CLASS} > .euiTabs {
    display: none;
  }
  &.${SETTINGS_TAB_CLASS} .euiTabs .euiSpacer {
    display: none;
  }
  /* Hide spacers that are direct children of tab panels to clean up the layout */
  div[role='tabpanel'] > .euiSpacer {
    display: none;
  }
`;

/*
 * Fixes tabs to the top and allows the content to scroll.
 */
const ScrollableFlyoutTabbedContent = props => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column",
  gutterSize: "none",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 47,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: true,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 48,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, (0, _extends2.default)({}, props, {
  className: SETTINGS_TAB_CLASS,
  css: hiddenTabsStyles,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 49,
    columnNumber: 7
  }
}))));
const useTabsView = ({
  connectorId,
  defaultSelectedTabId,
  onConnectorIdSelected,
  onGenerate,
  onSettingsReset,
  onSettingsSave,
  onSettingsChanged,
  settings
}) => {
  var _tabs$find;
  const {
    settingsView,
    actionButtons: filterActionButtons
  } = (0, _use_settings_view.useSettingsView)({
    connectorId,
    onConnectorIdSelected,
    onGenerate,
    onSettingsReset,
    onSettingsSave,
    onSettingsChanged,
    settings,
    showConnectorSelector: true
  });
  const {
    scheduleView,
    actionButtons: scheduleTabButtons
  } = (0, _use_schedule_view.useScheduleView)();
  const settingsTab = (0, _react.useMemo)(() => ({
    id: _constants.SETTINGS_TAB_ID,
    name: i18n.SETTINGS_TAB_LABEL,
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 11
      }
    }), settingsView)
  }), [settingsView]);
  const scheduleTab = (0, _react.useMemo)(() => ({
    id: _constants.SCHEDULE_TAB_ID,
    name: i18n.SCHEDULE_TAB_LABEL,
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 11
      }
    }), scheduleView)
  }), [scheduleView]);
  const tabs = (0, _react.useMemo)(() => {
    return [settingsTab, scheduleTab];
  }, [scheduleTab, settingsTab]);
  const [selectedTabId, setSelectedTabId] = (0, _react.useState)(defaultSelectedTabId !== null && defaultSelectedTabId !== void 0 ? defaultSelectedTabId : tabs[0].id);
  const selectedTab = (_tabs$find = tabs.find(tab => tab.id === selectedTabId)) !== null && _tabs$find !== void 0 ? _tabs$find : tabs[0];
  (0, _react.useEffect)(() => {
    if (!tabs.find(tab => tab.id === selectedTabId)) {
      // Switch to first tab if currently selected tab is not available for this rule
      setSelectedTabId(tabs[0].id);
    }
  }, [tabs, selectedTabId]);
  const onTabClick = tab => {
    setSelectedTabId(tab.id);
  };
  const tabsContainer = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(ScrollableFlyoutTabbedContent, {
      tabs: tabs,
      selectedTab: selectedTab,
      onTabClick: onTabClick,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 7
      }
    });
  }, [selectedTab, tabs]);
  const actionButtons = (0, _react.useMemo)(() => selectedTabId === 'settings' ? filterActionButtons : scheduleTabButtons, [filterActionButtons, scheduleTabButtons, selectedTabId]);
  return {
    tabsContainer,
    actionButtons
  };
};
exports.useTabsView = useTabsView;