"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.History = void 0;
var _eui = require("@elastic/eui");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _react = _interopRequireWildcard(require("react"));
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _use_attack_discovery_history_timerange = require("../../use_attack_discovery_history_timerange");
var _attack_discovery_panel = require("../attack_discovery_panel");
var _empty_prompt = require("../empty_states/empty_prompt");
var _get_initial_selection = require("./get_initial_selection");
var _generations = require("./generations");
var _helpers = require("../../helpers");
var _search_and_filter = require("./search_and_filter");
var _translations = require("./search_and_filter/translations");
var _summary = require("../summary");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_dismiss_attack_discovery_generations = require("../../use_dismiss_attack_discovery_generations");
var _use_ids_from_url = require("./use_ids_from_url");
var _use_find_attack_discoveries = require("../../use_find_attack_discoveries");
var _use_get_attack_discovery_generations = require("../../use_get_attack_discovery_generations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/attack_discovery/pages/results/history/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_PER_PAGE = 10;
const GET_ATTACK_DISCOVERY_GENERATIONS_SIZE = 50; // fetch up to 50 generations, with no filter by status
const ITEMS_PER_PAGE_OPTIONS = [10, 20, 50];
const EMPTY_ATTACK_DISCOVERY_ALERTS = [];
const FIRST_PAGE = 1; // CAUTION: sever-side API uses a 1-based page index convention (for consistency with similar existing APIs)

const EMPTY_REPLACEMENTS = {};
const EMPTY_QUERY = '';
const HistoryComponent = ({
  aiConnectors,
  localStorageAttackDiscoveryMaxAlerts,
  onGenerate,
  onToggleShowAnonymized,
  showAnonymized
}) => {
  var _data$data, _data$unique_alert_id, _data$total2, _data$data2, _aiConnectors$length, _data$total3;
  const {
    assistantAvailability,
    http
  } = (0, _elasticAssistant.useAssistantContext)();
  const {
    ids: filterByAlertIds,
    setIdsUrl: setFilterByAlertIds
  } = (0, _use_ids_from_url.useIdsFromUrl)();
  const {
    historyStart,
    setHistoryStart,
    historyEnd,
    setHistoryEnd
  } = (0, _use_attack_discovery_history_timerange.useAttackDiscoveryHistoryTimerange)();

  // search bar query:
  const [query, setQuery] = (0, _useLocalStorage.default)(`${_elasticAssistant.DEFAULT_ASSISTANT_NAMESPACE}.${_elasticAssistant.ATTACK_DISCOVERY_STORAGE_KEY}.${_elasticAssistant.HISTORY_QUERY_LOCAL_STORAGE_KEY}`, EMPTY_QUERY);

  /**
   * `undefined`: show both shared, and only visible to me Attack discoveries. `true`: show only shared Attack discoveries. `false`: show only visible to me Attack discoveries.
   */
  const [shared, setShared] = (0, _react.useState)(undefined);
  const [page, setPage] = _react.default.useState(FIRST_PAGE); // one-based, per API convention
  const [perPage, setPerPage] = (0, _react.useState)(DEFAULT_PER_PAGE);
  const onChangePage = (0, _react.useCallback)(zeroBasedPageIndex => {
    const oneBasedPageIndex = zeroBasedPageIndex + 1; // convert to one-based for API

    setPage(oneBasedPageIndex);
    setSelectedAttackDiscoveries({});
  }, []);
  const setIsSelected = (0, _react.useCallback)(({
    id,
    selected
  }) => setSelectedAttackDiscoveries(prevSelected => ({
    ...prevSelected,
    [id]: selected
  })), []);
  const onChangeItemsPerPage = (0, _react.useCallback)(pageSize => {
    setPage(FIRST_PAGE);
    setPerPage(pageSize); // convert to zero-based for pagination component
    setSelectedAttackDiscoveries({});
  }, []);
  const [statusItems, setStatusItems] = (0, _react.useState)([{
    checked: 'on',
    'data-test-subj': 'open',
    label: _translations.OPEN
  }, {
    checked: 'on',
    'data-test-subj': 'acknowledged',
    label: _translations.ACKNOWLEDGED
  }, {
    checked: undefined,
    'data-test-subj': 'closed',
    label: _translations.CLOSED
  }]);
  const selectedAlertWorkflowStatus = (0, _react.useMemo)(() => {
    return statusItems.filter(item => item.checked === 'on').map(item => item.label.toLowerCase());
  }, [statusItems]);
  const [selectedConnectorNames, setSelectedConnectorNames] = (0, _react.useState)([]);
  const {
    cancelRequest: cancelFindAttackDiscoveriesRequest,
    data,
    isLoading,
    refetch: refetchFindAttackDiscoveries
  } = (0, _use_find_attack_discoveries.useFindAttackDiscoveries)({
    connectorNames: selectedConnectorNames,
    end: historyEnd,
    ids: filterByAlertIds.length > 0 ? filterByAlertIds : undefined,
    http,
    isAssistantEnabled: assistantAvailability.isAssistantEnabled,
    page,
    perPage,
    search: query === null || query === void 0 ? void 0 : query.trim(),
    shared,
    start: historyStart,
    status: selectedAlertWorkflowStatus
  });
  const {
    cancelRequest: cancelGetAttackDiscoveryGenerations,
    data: generationsData,
    refetch: refetchGenerations
  } = (0, _use_get_attack_discovery_generations.useGetAttackDiscoveryGenerations)({
    http,
    isAssistantEnabled: assistantAvailability.isAssistantEnabled,
    size: GET_ATTACK_DISCOVERY_GENERATIONS_SIZE
  });
  const connectorNames = (0, _react.useMemo)(() => {
    var _data$connector_names;
    return (_data$connector_names = data === null || data === void 0 ? void 0 : data.connector_names) !== null && _data$connector_names !== void 0 ? _data$connector_names : [];
  }, [data]);
  const [selectedAttackDiscoveries, setSelectedAttackDiscoveries] = (0, _react.useState)((0, _get_initial_selection.getInitialSelection)((_data$data = data === null || data === void 0 ? void 0 : data.data) !== null && _data$data !== void 0 ? _data$data : EMPTY_ATTACK_DISCOVERY_ALERTS));
  (0, _react.useEffect)(() => {
    const intervalId = setInterval(() => {
      refetchGenerations();
    }, 10_000); // 10 seconds

    return () => {
      clearInterval(intervalId);
      cancelGetAttackDiscoveryGenerations();
      cancelFindAttackDiscoveriesRequest();
    };
  }, [cancelFindAttackDiscoveriesRequest, cancelGetAttackDiscoveryGenerations, refetchGenerations]);
  const pageCount = (0, _react.useMemo)(() => {
    var _data$total;
    return Math.ceil(((_data$total = data === null || data === void 0 ? void 0 : data.total) !== null && _data$total !== void 0 ? _data$total : 0) / perPage);
  }, [data, perPage]);
  const {
    mutateAsync: dismissAttackDiscoveryGeneration
  } = (0, _use_dismiss_attack_discovery_generations.useDismissAttackDiscoveryGeneration)();
  const onRefresh = (0, _react.useCallback)(async () => {
    refetchFindAttackDiscoveries();

    // Dismiss all successful generations
    // TODO: make this a bulk update:
    if (generationsData !== null && generationsData !== void 0 && generationsData.generations) {
      const dismissPromises = generationsData.generations.filter(({
        status
      }) => status === 'succeeded').map(({
        execution_uuid: executionUuid
      }) => dismissAttackDiscoveryGeneration({
        executionUuid
      }));
      await Promise.all(dismissPromises);
    }
    setSelectedAttackDiscoveries({});
  }, [dismissAttackDiscoveryGeneration, generationsData === null || generationsData === void 0 ? void 0 : generationsData.generations, refetchFindAttackDiscoveries]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "history",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_search_and_filter.SearchAndFilter, {
    aiConnectors: aiConnectors,
    connectorNames: connectorNames,
    end: historyEnd,
    filterByAlertIds: filterByAlertIds,
    isLoading: isLoading,
    onRefresh: onRefresh,
    query: query,
    setEnd: setHistoryEnd,
    setFilterByAlertIds: setFilterByAlertIds,
    selectedConnectorNames: selectedConnectorNames,
    setQuery: setQuery,
    setSelectedAttackDiscoveries: setSelectedAttackDiscoveries,
    setSelectedConnectorNames: setSelectedConnectorNames,
    setShared: setShared,
    setStart: setHistoryStart,
    setStatusItems: setStatusItems,
    statusItems: statusItems,
    shared: shared,
    start: historyStart,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_summary.Summary, {
    alertsCount: (_data$unique_alert_id = data === null || data === void 0 ? void 0 : data.unique_alert_ids_count) !== null && _data$unique_alert_id !== void 0 ? _data$unique_alert_id : 0,
    attackDiscoveriesCount: (_data$total2 = data === null || data === void 0 ? void 0 : data.total) !== null && _data$total2 !== void 0 ? _data$total2 : 0,
    isLoading: isLoading,
    lastUpdated: null,
    onToggleShowAnonymized: onToggleShowAnonymized,
    refetchFindAttackDiscoveries: refetchFindAttackDiscoveries,
    selectedAttackDiscoveries: selectedAttackDiscoveries,
    selectedConnectorAttackDiscoveries: (_data$data2 = data === null || data === void 0 ? void 0 : data.data) !== null && _data$data2 !== void 0 ? _data$data2 : EMPTY_ATTACK_DISCOVERY_ALERTS,
    setSelectedAttackDiscoveries: setSelectedAttackDiscoveries,
    showAnonymized: showAnonymized,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_generations.Generations, {
    aiConnectors: aiConnectors,
    data: generationsData,
    refetchGenerations: refetchGenerations,
    localStorageAttackDiscoveryMaxAlerts: localStorageAttackDiscoveryMaxAlerts,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 7
    }
  }), data != null && data.data.length === 0 && /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, {
    aiConnectorsCount: (_aiConnectors$length = aiConnectors === null || aiConnectors === void 0 ? void 0 : aiConnectors.length) !== null && _aiConnectors$length !== void 0 ? _aiConnectors$length : null,
    attackDiscoveriesCount: (_data$total3 = data === null || data === void 0 ? void 0 : data.total) !== null && _data$total3 !== void 0 ? _data$total3 : 0,
    isDisabled: !(aiConnectors !== null && aiConnectors !== void 0 && aiConnectors.length),
    isLoading: isLoading,
    onGenerate: onGenerate,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 9
    }
  }), data != null && data.data.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, data.data.map((attackDiscovery, i) => {
    var _attackDiscovery$repl;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: attackDiscovery.id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 254,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_attack_discovery_panel.AttackDiscoveryPanel, {
      attackDiscovery: attackDiscovery,
      initialIsOpen: (0, _helpers.getInitialIsOpen)(i),
      replacements: (_attackDiscovery$repl = attackDiscovery.replacements) !== null && _attackDiscovery$repl !== void 0 ? _attackDiscovery$repl : EMPTY_REPLACEMENTS,
      setIsSelected: setIsSelected,
      isSelected: selectedAttackDiscoveries[attackDiscovery.id],
      setSelectedAttackDiscoveries: setSelectedAttackDiscoveries,
      showAnonymized: showAnonymized,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 255,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 264,
        columnNumber: 15
      }
    }));
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTablePagination, {
    activePage: page - 1 // convert to zero-based for EUI
    ,
    "aria-label": i18n.PAGINATION_ARIA_LABEL,
    "data-test-subj": "pagination",
    itemsPerPage: perPage,
    itemsPerPageOptions: ITEMS_PER_PAGE_OPTIONS,
    pageCount: pageCount,
    onChangeItemsPerPage: onChangeItemsPerPage,
    onChangePage: onChangePage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 270,
      columnNumber: 11
    }
  })));
};
const History = exports.History = /*#__PURE__*/_react.default.memo(HistoryComponent);