"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UP_TO = exports.START_GENERATING_DISCOVERIES = exports.SELECT_A_CONNECTOR = exports.RESPONSES_FROM_AI_SYSTEMS = exports.NO_RESULTS_MATCH_YOUR_SEARCH = exports.LEARN_MORE = exports.HERE_ARE_SOME_THINGS_TO_TRY = exports.GENERATE_NEW_ATTACK_DISCOVERIES = exports.GENERATE = exports.EXPAND_THE_TIME_RANGE = exports.ALERTS_WILL_BE_ANALYZED = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALERTS_WILL_BE_ANALYZED = alertsCount => _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.pages.emptyPrompt.alertsWillBeAnalyzedTitle', {
  defaultMessage: '{alertsCount, plural, one {alert} other {alerts}} will be analyzed',
  values: {
    alertsCount
  }
});
exports.ALERTS_WILL_BE_ANALYZED = ALERTS_WILL_BE_ANALYZED;
const EXPAND_THE_TIME_RANGE = exports.EXPAND_THE_TIME_RANGE = _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.pages.emptyPrompt.expandTheTimeRangeLabel', {
  defaultMessage: 'Expand the time range'
});
const GENERATE = exports.GENERATE = _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.pages.emptyPrompt.generateLabel', {
  defaultMessage: 'Generate'
});
const GENERATE_NEW_ATTACK_DISCOVERIES = exports.GENERATE_NEW_ATTACK_DISCOVERIES = _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.pages.emptyPrompt.generateNewAttackDiscoveriesLabel', {
  defaultMessage: 'Generate new attack discoveries'
});
const HERE_ARE_SOME_THINGS_TO_TRY = exports.HERE_ARE_SOME_THINGS_TO_TRY = _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.pages.emptyPrompt.hereAreSomeThingsToTryTitle', {
  defaultMessage: 'Here are some things to try:'
});
const LEARN_MORE = exports.LEARN_MORE = _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.pages.emptyPrompt.learnMoreLabel', {
  defaultMessage: 'Learn more'
});
const NO_RESULTS_MATCH_YOUR_SEARCH = exports.NO_RESULTS_MATCH_YOUR_SEARCH = _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.pages.emptyPrompt.noResultsMatchYourSearchTitle', {
  defaultMessage: 'No results match your search criteria'
});
const RESPONSES_FROM_AI_SYSTEMS = exports.RESPONSES_FROM_AI_SYSTEMS = _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.pages.emptyPrompt.responsesFromAiSystemsTooltip', {
  defaultMessage: 'Responses from AI systems may not always be entirely accurate, although they can seem convincing. For more information on the Attack Discovery feature and its usage, please reference the documentation.'
});
const SELECT_A_CONNECTOR = exports.SELECT_A_CONNECTOR = _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.pages.emptyPrompt.selectAConnectorLabel', {
  defaultMessage: 'Select a connector'
});
const START_GENERATING_DISCOVERIES = exports.START_GENERATING_DISCOVERIES = _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.pages.emptyPrompt.startGeneratingDiscoveriesLabel', {
  defaultMessage: 'Start discovering attacks with the power of AI and Elastic Security.'
});
const UP_TO = exports.UP_TO = _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.pages.emptyPrompt.upToTitle', {
  defaultMessage: 'Up to'
});