"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasErrors = exports.default = exports.CloudAssetInventoryPolicyTemplateForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _std = require("@kbn/std");
var _use_kibana = require("../../hooks/use_kibana");
var _constants = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/asset_inventory/components/fleet_extensions/policy_template_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const hasErrors = validationResults => {
  if (!validationResults) return 0;
  const flattenedValidation = (0, _std.getFlattenedObject)(validationResults);
  const errors = Object.values(flattenedValidation).filter(value => Boolean(value)) || [];
  return errors.length;
};
exports.hasErrors = hasErrors;
const CloudAssetInventoryPolicyTemplateForm = exports.default = exports.CloudAssetInventoryPolicyTemplateForm = /*#__PURE__*/(0, _react.memo)(({
  newPolicy,
  onChange,
  validationResults,
  isEditPage,
  packageInfo,
  handleSetupTechnologyChange,
  isAgentlessEnabled,
  defaultSetupTechnology
}) => {
  const CLOUD_CONNECTOR_PACKAGE_VERSION_ENABLED_AWS = '0.18.0';
  const CLOUD_CONNECTOR_PACKAGE_VERSION_ENABLED_AZURE = '1.1.3';
  const {
    cloud,
    uiSettings
  } = (0, _use_kibana.useKibana)().services;
  const isValidFormState = !hasErrors(validationResults);
  const CLOUD_SETUP_MAPPING = {
    policyTemplate: _constants.ASSET_POLICY_TEMPLATE,
    defaultProvider: 'aws',
    namespaceSupportEnabled: true,
    name: _i18n.i18n.translate('xpack.securitySolution.assetInventory.assetIntegration.nameTitle', {
      defaultMessage: 'Cloud Asset Discovery'
    }),
    shortName: _i18n.i18n.translate('xpack.securitySolution.assetInventory.assetIntegration.shortNameTitle', {
      defaultMessage: 'CAD'
    }),
    overviewPath: `https://ela.st/cloud-asset-discovery-overview`,
    getStartedPath: `https://ela.st/cloud-asset-discovery-get-started`,
    showCloudTemplates: true,
    providers: {
      aws: {
        type: _constants.CLOUDBEAT_AWS,
        enableOrganization: true,
        cloudConnectorEnabledVersion: CLOUD_CONNECTOR_PACKAGE_VERSION_ENABLED_AWS,
        getStartedPath: `https://ela.st/cloud-asset-discovery-get-started-aws.html`,
        inputFieldMapping: {
          access_key_id: 'aws.access_key_id',
          secret_access_key: 'aws.secret_access_key',
          session_token: 'aws.session_token',
          role_arn: 'aws.role_arn',
          shared_credential_file: 'aws.shared_credential_file',
          credential_profile_name: 'aws.credential_profile_name'
        }
      },
      gcp: {
        type: _constants.CLOUDBEAT_GCP,
        enableOrganization: true,
        getStartedPath: `https://ela.st/cloud-asset-discovery-get-started-gcp.html`,
        enabled: true
      },
      azure: {
        type: _constants.CLOUDBEAT_AZURE,
        enabled: true,
        enableOrganization: true,
        getStartedPath: `https://ela.st/cloud-asset-discovery-get-started-azure.html`,
        manualFieldsEnabled: true,
        cloudConnectorEnabledVersion: CLOUD_CONNECTOR_PACKAGE_VERSION_ENABLED_AZURE
      }
    }
  };
  const updatePolicy = (0, _react.useCallback)(({
    updatedPolicy,
    isExtensionLoaded,
    isValid
  }) => {
    onChange({
      isValid,
      updatedPolicy,
      isExtensionLoaded: isExtensionLoaded !== undefined ? isExtensionLoaded : true
    });
  }, [onChange]);
  return /*#__PURE__*/_react.default.createElement(_cloudSecurityPosture.CloudSetup, {
    configuration: CLOUD_SETUP_MAPPING,
    newPolicy: newPolicy,
    updatePolicy: updatePolicy,
    packageInfo: packageInfo,
    isEditPage: isEditPage,
    validationResults: validationResults,
    defaultSetupTechnology: defaultSetupTechnology,
    isAgentlessEnabled: isAgentlessEnabled,
    handleSetupTechnologyChange: handleSetupTechnologyChange,
    isValid: isValidFormState,
    cloud: cloud,
    uiSettings: uiSettings,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 9
    }
  });
});
CloudAssetInventoryPolicyTemplateForm.displayName = 'CloudAssetInventoryPolicyTemplateForm';

// eslint-disable-next-line import/no-default-export