"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSecurityV2SubFeaturesMap = exports.getSecurityV2BaseKibanaSubFeatureIds = void 0;
var _product_features_keys = require("../../product_features_keys");
var _constants = require("../../constants");
var _kibana_sub_features = require("../kibana_sub_features");
var _utils = require("../../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const replacements = {
  [_product_features_keys.SecuritySubFeatureId.endpointList]: [{
    feature: _constants.SECURITY_FEATURE_ID_V4
  }],
  [_product_features_keys.SecuritySubFeatureId.workflowInsights]: [{
    feature: _constants.SECURITY_FEATURE_ID_V4
  }],
  [_product_features_keys.SecuritySubFeatureId.globalArtifactManagement]: [{
    feature: _constants.SECURITY_FEATURE_ID_V4
  }],
  [_product_features_keys.SecuritySubFeatureId.trustedApplications]: [{
    feature: _constants.SECURITY_FEATURE_ID_V4,
    additionalPrivileges: {
      trusted_applications_all: ['global_artifact_management_all']
    }
  }],
  [_product_features_keys.SecuritySubFeatureId.hostIsolationExceptionsBasic]: [{
    feature: _constants.SECURITY_FEATURE_ID_V4,
    additionalPrivileges: {
      host_isolation_exceptions_all: ['global_artifact_management_all']
    }
  }],
  [_product_features_keys.SecuritySubFeatureId.blocklist]: [{
    feature: _constants.SECURITY_FEATURE_ID_V4,
    additionalPrivileges: {
      blocklist_all: ['global_artifact_management_all']
    }
  }],
  [_product_features_keys.SecuritySubFeatureId.eventFilters]: [{
    feature: _constants.SECURITY_FEATURE_ID_V4,
    additionalPrivileges: {
      event_filters_all: ['global_artifact_management_all']
    }
  }],
  [_product_features_keys.SecuritySubFeatureId.endpointExceptions]: [{
    feature: _constants.SECURITY_FEATURE_ID_V4,
    additionalPrivileges: {
      endpoint_exceptions_all: ['global_artifact_management_all']
    }
  }],
  [_product_features_keys.SecuritySubFeatureId.policyManagement]: [{
    feature: _constants.SECURITY_FEATURE_ID_V4
  }],
  [_product_features_keys.SecuritySubFeatureId.responseActionsHistory]: [{
    feature: _constants.SECURITY_FEATURE_ID_V4
  }],
  [_product_features_keys.SecuritySubFeatureId.hostIsolation]: [{
    feature: _constants.SECURITY_FEATURE_ID_V4
  }],
  [_product_features_keys.SecuritySubFeatureId.processOperations]: [{
    feature: _constants.SECURITY_FEATURE_ID_V4
  }],
  [_product_features_keys.SecuritySubFeatureId.fileOperations]: [{
    feature: _constants.SECURITY_FEATURE_ID_V4
  }],
  [_product_features_keys.SecuritySubFeatureId.executeAction]: [{
    feature: _constants.SECURITY_FEATURE_ID_V4
  }],
  [_product_features_keys.SecuritySubFeatureId.scanAction]: [{
    feature: _constants.SECURITY_FEATURE_ID_V4
  }]
};

/**
 * Sub-features that will always be available for Security
 * regardless of the product type.
 */
const getSecurityV2BaseKibanaSubFeatureIds = ({
  experimentalFeatures
}) => [];

/**
 * Defines all the Security Assistant subFeatures available.
 * The order of the subFeatures is the order they will be displayed
 */
exports.getSecurityV2BaseKibanaSubFeatureIds = getSecurityV2BaseKibanaSubFeatureIds;
const getSecurityV2SubFeaturesMap = ({
  experimentalFeatures
}) => {
  const securitySubFeaturesList = [[_product_features_keys.SecuritySubFeatureId.endpointList, (0, _kibana_sub_features.endpointListSubFeature)()], [_product_features_keys.SecuritySubFeatureId.workflowInsights, (0, _kibana_sub_features.workflowInsightsSubFeature)()], [_product_features_keys.SecuritySubFeatureId.globalArtifactManagement, (0, _kibana_sub_features.globalArtifactManagementSubFeature)(experimentalFeatures)], [_product_features_keys.SecuritySubFeatureId.trustedApplications, (0, _kibana_sub_features.trustedApplicationsSubFeature)()], [_product_features_keys.SecuritySubFeatureId.hostIsolationExceptionsBasic, (0, _kibana_sub_features.hostIsolationExceptionsBasicSubFeature)()], [_product_features_keys.SecuritySubFeatureId.blocklist, (0, _kibana_sub_features.blocklistSubFeature)()], [_product_features_keys.SecuritySubFeatureId.eventFilters, (0, _kibana_sub_features.eventFiltersSubFeature)()], [_product_features_keys.SecuritySubFeatureId.endpointExceptions, (0, _kibana_sub_features.endpointExceptionsSubFeature)()], [_product_features_keys.SecuritySubFeatureId.policyManagement, (0, _kibana_sub_features.policyManagementSubFeature)()], [_product_features_keys.SecuritySubFeatureId.responseActionsHistory, (0, _kibana_sub_features.responseActionsHistorySubFeature)()], [_product_features_keys.SecuritySubFeatureId.hostIsolation, (0, _kibana_sub_features.hostIsolationSubFeature)()], [_product_features_keys.SecuritySubFeatureId.processOperations, (0, _kibana_sub_features.processOperationsSubFeature)()], [_product_features_keys.SecuritySubFeatureId.fileOperations, (0, _kibana_sub_features.fileOperationsSubFeature)()], [_product_features_keys.SecuritySubFeatureId.executeAction, (0, _kibana_sub_features.executeActionSubFeature)()], [_product_features_keys.SecuritySubFeatureId.scanAction, (0, _kibana_sub_features.scanActionSubFeature)()]];
  const securitySubFeaturesMap = new Map(securitySubFeaturesList.map(([id, originalSubFeature]) => {
    let subFeature = originalSubFeature;
    const featureReplacements = replacements[id];
    if (featureReplacements) {
      subFeature = (0, _utils.addSubFeatureReplacements)(subFeature, featureReplacements);
    }

    // If the feature is space-aware, we need to set false to the requireAllSpaces flag and remove the privilegesTooltip
    if (experimentalFeatures.endpointManagementSpaceAwarenessEnabled) {
      subFeature = {
        ...subFeature,
        requireAllSpaces: false,
        privilegesTooltip: undefined
      };
    }
    return [id, subFeature];
  }));

  // Remove disabled experimental features
  if (!experimentalFeatures.endpointManagementSpaceAwarenessEnabled) {
    securitySubFeaturesMap.delete(_product_features_keys.SecuritySubFeatureId.globalArtifactManagement);
  }
  return Object.freeze(securitySubFeaturesMap);
};
exports.getSecurityV2SubFeaturesMap = getSecurityV2SubFeaturesMap;