"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DevToolsCode = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _reactHookForm = require("react-hook-form");
var _types = require("../../../types");
var _user_query = require("../../../utils/user_query");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_playground/public/components/view_code/examples/dev_tools.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DevToolsCode = () => {
  const {
    getValues,
    formState: {
      errors: formErrors
    }
  } = (0, _reactHookForm.useFormContext)();
  const {
    [_types.PlaygroundFormFields.indices]: indices,
    [_types.PlaygroundFormFields.elasticsearchQuery]: esQuery,
    [_types.PlaygroundFormFields.searchQuery]: searchQuery,
    [_types.PlaygroundFormFields.userElasticsearchQuery]: userElasticsearchQuery
  } = getValues();
  const query = (0, _user_query.elasticsearchQueryObject)(esQuery, userElasticsearchQuery, formErrors[_types.PlaygroundFormFields.userElasticsearchQuery]);
  const replacedQuery = (searchQuery !== null && searchQuery !== void 0 ? searchQuery : '') ? JSON.stringify(query, null, 2).replace(/\"{query}\"/g, JSON.stringify(searchQuery)) : JSON.stringify(query, null, 2);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    isCopyable: true,
    overflowHeight: "100%",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  }, `POST ${indices.join(',')}/_search
${replacedQuery}
`);
};
exports.DevToolsCode = DevToolsCode;