"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchQueryMode = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _eui = require("@elastic/eui");
var _use_usage_tracker = require("../../hooks/use_usage_tracker");
var _constants = require("../../analytics/constants");
var _playground_body_section = require("../playground_body_section");
var _query_viewer = require("./query_viewer");
var _query_output = require("./query_output");
var _query_side_panel = require("./query_side_panel");
var _use_elasticsearch_query = require("../../hooks/use_elasticsearch_query");
var _types = require("../../types");
var _styles = require("./styles");
var _user_query = require("../../utils/user_query");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_playground/public/components/query_mode/search_query_mode.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SearchQueryMode = ({
  pageMode
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const usageTracker = (0, _use_usage_tracker.useUsageTracker)();
  (0, _react.useEffect)(() => {
    usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.load(_constants.AnalyticsEvents.queryModeLoaded);
  }, [usageTracker]);
  const {
    executeQuery,
    data,
    error,
    isError,
    fetchStatus
  } = (0, _use_elasticsearch_query.useElasticsearchQuery)(pageMode);
  const {
    field: {
      value: searchQuery
    }
  } = (0, _reactHookForm.useController)({
    name: _types.PlaygroundFormFields.searchQuery
  });
  const {
    field: {
      value: question
    }
  } = (0, _reactHookForm.useController)({
    name: _types.PlaygroundFormFields.question
  });
  const {
    field: {
      value: userElasticsearchQuery
    },
    fieldState: {
      invalid: userElasticsearchQueryInvalid
    }
  } = (0, _reactHookForm.useController)({
    name: _types.PlaygroundFormFields.userElasticsearchQuery
  });
  const executeQueryDisabled = (0, _user_query.disableExecuteQuery)(userElasticsearchQuery === null || !userElasticsearchQueryInvalid, pageMode === _types.PlaygroundPageMode.chat ? question : searchQuery);
  const isLoading = fetchStatus !== 'idle';
  return /*#__PURE__*/_react.default.createElement(_playground_body_section.PlaygroundBodySection, {
    color: euiTheme.colors.backgroundBasePlain,
    dataTestSubj: "queryModeSection",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 6,
    css: (0, _styles.QueryViewContainer)(euiTheme),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none",
    hasShadow: false,
    css: _styles.PanelFillContainer,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiResizableContainer, {
    direction: "vertical",
    css: _styles.FullHeight,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 13
    }
  }, (EuiResizablePanel, EuiResizableButton) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(EuiResizablePanel, {
    initialSize: 60,
    minSize: "20%",
    tabIndex: 0,
    paddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_query_viewer.ElasticsearchQueryViewer, {
    executeQuery: executeQuery,
    executeQueryDisabled: executeQueryDisabled,
    isLoading: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react.default.createElement(EuiResizableButton, {
    accountForScrollbars: "both",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(EuiResizablePanel, {
    initialSize: 40,
    minSize: "25%",
    tabIndex: 0,
    paddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_query_output.ElasticsearchQueryOutput, {
    queryResponse: data,
    queryError: error,
    isError: isError,
    isLoading: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 21
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    className: "eui-yScroll",
    css: (0, _styles.QueryViewSidebarContainer)(euiTheme),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_query_side_panel.QuerySidePanel, {
    pageMode: pageMode,
    executeQuery: executeQuery,
    executeQueryDisabled: executeQueryDisabled,
    isLoading: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 11
    }
  }))));
};
exports.SearchQueryMode = SearchQueryMode;