"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LicenseContext = exports.ConnectorConfigurationComponent = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireDefault(require("fast-deep-equal/react"));
var _connector_configuration_utils = require("../../utils/connector_configuration_utils");
var _ = require("../..");
var _connector_configuration_form = require("./connector_configuration_form");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/src/platform/packages/shared/kbn-search-connectors/components/configuration/connector_configuration.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function entryToDisplaylistItem(entry) {
  return {
    description: entry.sensitive && !!entry.value ? '********' : String(entry.value) || '--',
    title: entry.label
  };
}
const LicenseContext = exports.LicenseContext = /*#__PURE__*/(0, _react.createContext)({
  hasPlatinumLicense: false,
  subscriptionLink: undefined,
  stackManagementLink: undefined
});
const ConnectorConfigurationComponent = ({
  children,
  connector,
  hasPlatinumLicense,
  isDisabled,
  isLoading,
  saveConfig,
  saveAndSync,
  onEditStateChange,
  subscriptionLink,
  stackManagementLink
}) => {
  var _features$FeatureName;
  const configurationRef = (0, _react.useRef)({});
  const {
    configuration,
    error,
    status: connectorStatus,
    is_native: isNative,
    features
  } = connector;
  const hasDocumentLevelSecurity = Boolean(features === null || features === void 0 ? void 0 : (_features$FeatureName = features[_.FeatureName.DOCUMENT_LEVEL_SECURITY]) === null || _features$FeatureName === void 0 ? void 0 : _features$FeatureName.enabled);
  const [isEditing, setIsEditing] = (0, _react.useState)(false);
  (0, _react.useEffect)(function propogateEditState() {
    if (onEditStateChange) {
      onEditStateChange(isEditing);
    }
  }, [isEditing, onEditStateChange]);
  (0, _react.useEffect)(() => {
    if (!(0, _react2.default)(configuration, configurationRef.current)) {
      configurationRef.current = configuration;
      setIsEditing(false);
    }
  }, [configuration]);
  (0, _react.useEffect)(() => {
    if (Object.keys(configuration || {}).length > 0 && (connectorStatus === _.ConnectorStatus.CREATED || connectorStatus === _.ConnectorStatus.NEEDS_CONFIGURATION)) {
      // Only start in edit mode if we haven't configured yet
      // Necessary to prevent a race condition between saving config and getting updated connector
      setIsEditing(true);
    }
  }, [configuration, connectorStatus]);
  const configView = (0, _connector_configuration_utils.sortAndFilterConnectorConfiguration)(configuration, isNative);
  const uncategorizedDisplayList = configView.unCategorizedItems.map(entryToDisplaylistItem);
  return /*#__PURE__*/_react.default.createElement(LicenseContext.Provider, {
    value: {
      hasPlatinumLicense,
      stackManagementLink,
      subscriptionLink
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 7
    }
  }, children && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 22
    }
  }, children), !uncategorizedDisplayList.length && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    title: _i18n.i18n.translate('searchConnectors.configurationConnector.config.noConfigCallout.title', {
      defaultMessage: 'No configuration fields'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('searchConnectors.configurationConnector.config.noConfigCallout.description', {
    defaultMessage: 'This connector has no configuration fields. Has your connector connected successfully to Elasticsearch and set its configuration?'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 9
    }
  }, isEditing ? /*#__PURE__*/_react.default.createElement(_connector_configuration_form.ConnectorConfigurationForm, (0, _extends2.default)({
    cancelEditing: () => setIsEditing(false),
    configuration: configuration,
    hasDocumentLevelSecurity: hasDocumentLevelSecurity,
    isLoading: isLoading,
    isNative: isNative,
    saveConfig: config => {
      saveConfig(config);
      setIsEditing(false);
    }
  }, saveAndSync && {
    saveAndSync: config => {
      saveAndSync(config);
      setIsEditing(false);
    }
  }, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 13
    }
  })) : uncategorizedDisplayList.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    listItems: uncategorizedDisplayList,
    className: "eui-textBreakWord",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 19
    }
  })), configView.categories.length > 0 && configView.categories.map(category => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    key: category.key,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 27
    }
  }, category.label))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    listItems: category.configEntries.map(entryToDisplaylistItem),
    className: "eui-textBreakWord",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 25
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "entSearchContent-connector-configuration-editConfiguration",
    "data-telemetry-id": "entSearchContent-connector-overview-configuration-editConfiguration",
    onClick: () => setIsEditing(!isEditing),
    isDisabled: isDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 23
    }
  }, _i18n.i18n.translate('searchConnectors.configurationConnector.config.editButton.title', {
    defaultMessage: 'Edit configuration'
  }))))))), !!error && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    title: _i18n.i18n.translate('searchConnectors.configurationConnector.config.error.title', {
      defaultMessage: 'Connector error'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 15
    }
  }, error)))));
};
exports.ConnectorConfigurationComponent = ConnectorConfigurationComponent;