"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getChromiumPackage = void 0;
var _os = _interopRequireDefault(require("os"));
var _paths = require("./paths");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const paths = new _paths.ChromiumArchivePaths();
const getChromiumPackage = () => {
  const platform = process.platform;
  const architecture = _os.default.arch();
  const chromiumPackageInfo = paths.find(process.platform, architecture);
  if (!chromiumPackageInfo) {
    throw new Error(`Unsupported platform: ${platform}-${architecture}`);
  }
  return chromiumPackageInfo;
};
exports.getChromiumPackage = getChromiumPackage;