"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RemoteClusterTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _constants = require("../../../constants");
var _constants2 = require("../../../../../common/constants");
var _services = require("../../../services");
var _components = require("../components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/remote_clusters/public/application/sections/remote_cluster_list/remote_cluster_table/remote_cluster_table.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getFilteredClusters = (clusters, queryText) => {
  if (queryText) {
    const normalizedSearchText = queryText.toLowerCase();
    return clusters.filter(cluster => {
      const {
        name,
        seeds,
        proxyAddress
      } = cluster;
      const normalizedName = name.toLowerCase();
      if (normalizedName.toLowerCase().includes(normalizedSearchText)) {
        return true;
      }
      if (proxyAddress && proxyAddress.toLowerCase().includes(normalizedSearchText)) {
        return true;
      }
      if (seeds) {
        return seeds.some(seed => seed.includes(normalizedSearchText));
      }
      return false;
    });
  } else {
    return clusters;
  }
};
class RemoteClusterTable extends _react.Component {
  static getDerivedStateFromProps(props, state) {
    const {
      clusters
    } = props;
    const {
      prevClusters,
      queryText
    } = state;

    // If a remote cluster gets deleted, we need to recreate the cached filtered clusters.
    if (prevClusters !== clusters) {
      return {
        prevClusters: clusters,
        filteredClusters: getFilteredClusters(clusters, queryText)
      };
    }
    return null;
  }
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "onSearch", ({
      query
    }) => {
      // There's no need to update the state if there arent any search params
      if (!query) {
        return;
      }
      const {
        clusters
      } = this.props;
      const {
        text
      } = query;

      // We cache the filtered indices instead of calculating them inside render() because
      // of https://github.com/elastic/eui/issues/3445.
      this.setState({
        queryText: text,
        filteredClusters: getFilteredClusters(clusters, text)
      });
    });
    this.state = {
      prevClusters: props.clusters,
      selectedItems: [],
      filteredClusters: props.clusters,
      queryText: ''
    };
  }
  render() {
    const {
      openDetailPanel
    } = this.props;
    const {
      selectedItems,
      filteredClusters
    } = this.state;
    const {
      history
    } = (0, _services.getRouter)();
    const columns = [{
      field: 'name',
      name: _i18n.i18n.translate('xpack.remoteClusters.remoteClusterList.table.nameColumnTitle', {
        defaultMessage: 'Name'
      }),
      sortable: true,
      truncateText: false,
      render: (name, {
        isConfiguredByNode,
        hasDeprecatedProxySetting
      }) => {
        const link = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "remoteClustersTableListClusterLink",
          onClick: () => {
            (0, _services.trackUiMetric)(_services.METRIC_TYPE.CLICK, _constants.UIM_SHOW_DETAILS_CLICK);
            openDetailPanel(name);
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 125,
            columnNumber: 13
          }
        }, name);
        if (isConfiguredByNode) {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
            gutterSize: "s",
            alignItems: "center",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 138,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 139,
              columnNumber: 17
            }
          }, link), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false,
            "data-test-subj": "remoteClustersTableListClusterDefinedByNodeTooltip",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 141,
              columnNumber: 17
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
            type: "info",
            color: "subdued",
            content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.remoteClusters.remoteClusterList.table.isConfiguredByNodeMessage",
              defaultMessage: "Defined in elasticsearch.yml",
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 149,
                columnNumber: 23
              }
            }),
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 145,
              columnNumber: 19
            }
          })));
        }
        if (hasDeprecatedProxySetting) {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
            gutterSize: "s",
            alignItems: "center",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 162,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false,
            "data-test-subj": "remoteClustersTableListClusterWithDeprecatedSettingTooltip",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 163,
              columnNumber: 17
            }
          }, link), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false,
            "data-test-subj": "remoteClustersTableListDeprecatedSetttingsTooltip",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 170,
              columnNumber: 17
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
            type: "warning",
            color: "warning",
            content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.remoteClusters.remoteClusterList.table.hasDeprecatedSettingMessage",
              defaultMessage: "Edit this cluster to update the deprecated settings.",
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 178,
                columnNumber: 23
              }
            }),
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 174,
              columnNumber: 19
            }
          })));
        }
        return link;
      }
    }, {
      field: 'isConnected',
      name: _i18n.i18n.translate('xpack.remoteClusters.remoteClusterList.table.connectedColumnTitle', {
        defaultMessage: 'Status'
      }),
      sortable: true,
      render: (isConnected, {
        mode
      }) => /*#__PURE__*/_react.default.createElement(_components.ConnectionStatus, {
        isConnected: isConnected,
        mode: mode,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 199,
          columnNumber: 11
        }
      }),
      width: '240px'
    }, {
      field: 'mode',
      name: _i18n.i18n.translate('xpack.remoteClusters.remoteClusterList.table.modeColumnTitle', {
        defaultMessage: 'Mode'
      }),
      sortable: true,
      render: mode => {
        let modeMessage;
        mode === _constants2.PROXY_MODE ? modeMessage = mode : modeMessage = _i18n.i18n.translate('xpack.remoteClusters.remoteClusterList.table.sniffModeDescription', {
          defaultMessage: 'default'
        });
        const modeMessageComponent = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          className: "remoteClustersConnectionMode__message",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 220,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          id: "xpack.remoteClusters.remoteClusterList.table.sniffModeDescription",
          "data-test-subj": "remoteClusterConnectionModeMessage",
          size: "s",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 221,
            columnNumber: 15
          }
        }, modeMessage));
        return modeMessageComponent;
      }
    }, {
      field: 'mode',
      name: _i18n.i18n.translate('xpack.remoteClusters.remoteClusterList.table.addressesColumnTitle', {
        defaultMessage: 'Addresses'
      }),
      'data-test-subj': 'remoteClustersAddress',
      truncateText: true,
      render: (mode, {
        seeds,
        proxyAddress
      }) => {
        const clusterAddressString = mode === _constants2.PROXY_MODE ? proxyAddress : seeds.join(', ');
        const connectionMode = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          className: "remoteClustersConnectionAddress__message",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 243,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          "data-test-subj": "remoteClusterConnectionAddressMessage",
          size: "s",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 244,
            columnNumber: 15
          }
        }, clusterAddressString));
        return connectionMode;
      }
    }, {
      field: 'securityModel',
      name: _i18n.i18n.translate('xpack.remoteClusters.remoteClusterList.table.authTypeColumnTitle', {
        defaultMessage: 'Authentication type'
      }),
      sortable: true,
      render: securityModel => {
        return /*#__PURE__*/_react.default.createElement(_components.SecurityModel, {
          securityModel: securityModel,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 259,
            columnNumber: 18
          }
        });
      }
    }, {
      field: 'mode',
      name: _i18n.i18n.translate('xpack.remoteClusters.remoteClusterList.table.connectionsColumnTitle', {
        defaultMessage: 'Connections'
      }),
      sortable: true,
      width: '160px',
      align: 'right',
      render: (mode, {
        connectedNodesCount,
        connectedSocketsCount
      }) => {
        const remoteNodesCount = mode === _constants2.PROXY_MODE ? connectedSocketsCount : connectedNodesCount;
        const connectionMode = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          className: "remoteClustersNodeCount__message",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 277,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          "data-test-subj": "remoteClusterNodeCountMessage",
          size: "s",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 278,
            columnNumber: 15
          }
        }, remoteNodesCount));
        return connectionMode;
      }
    }, {
      name: _i18n.i18n.translate('xpack.remoteClusters.remoteClusterList.table.actionsColumnTitle', {
        defaultMessage: 'Actions'
      }),
      width: '100px',
      actions: [{
        render: ({
          name,
          isConfiguredByNode
        }) => {
          const label = isConfiguredByNode ? _i18n.i18n.translate('xpack.remoteClusters.remoteClusterList.table.actionBlockedEditDescription', {
            defaultMessage: `Remote clusters defined in elasticsearch.yml can't be edited`
          }) : _i18n.i18n.translate('xpack.remoteClusters.remoteClusterList.table.actionEditDescription', {
            defaultMessage: 'Edit remote cluster'
          });
          return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
            content: label,
            delay: "long",
            disableScreenReaderOutput: true,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 309,
              columnNumber: 17
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
            "data-test-subj": "remoteClusterTableRowEditButton",
            "aria-label": label,
            iconType: "pencil",
            color: "primary",
            isDisabled: isConfiguredByNode
          }, (0, _public.reactRouterNavigate)(history, `/edit/${name}`), {
            disabled: isConfiguredByNode,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 310,
              columnNumber: 19
            }
          })));
        }
      }, {
        render: ({
          name,
          isConfiguredByNode
        }) => {
          const label = isConfiguredByNode ? _i18n.i18n.translate('xpack.remoteClusters.remoteClusterList.table.actionBlockedDeleteDescription', {
            defaultMessage: `Remote clusters defined in elasticsearch.yml can't be deleted`
          }) : _i18n.i18n.translate('xpack.remoteClusters.remoteClusterList.table.actionDeleteDescription', {
            defaultMessage: 'Delete remote cluster'
          });
          return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
            content: label,
            delay: "long",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 340,
              columnNumber: 17
            }
          }, /*#__PURE__*/_react.default.createElement(_components.RemoveClusterButtonProvider, {
            clusterNames: [name],
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 341,
              columnNumber: 19
            }
          }, removeCluster => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
            "data-test-subj": "remoteClusterTableRowRemoveButton",
            "aria-label": label,
            iconType: "trash",
            color: "danger",
            isDisabled: isConfiguredByNode,
            onClick: removeCluster,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 343,
              columnNumber: 23
            }
          })));
        }
      }]
    }];
    const sorting = {
      sort: {
        field: 'name',
        direction: 'asc'
      }
    };
    const search = {
      toolsLeft: selectedItems.length ? /*#__PURE__*/_react.default.createElement(_components.RemoveClusterButtonProvider, {
        clusterNames: selectedItems.map(({
          name
        }) => name),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 370,
          columnNumber: 9
        }
      }, removeCluster => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        color: "danger",
        onClick: removeCluster,
        "data-test-subj": "remoteClusterBulkDeleteButton",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 372,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.remoteClusters.remoteClusterList.table.removeButtonLabel",
        defaultMessage: "Remove {count, plural, one {remote cluster} other {{count} remote clusters}}",
        values: {
          count: selectedItems.length
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 377,
          columnNumber: 15
        }
      }))) : undefined,
      toolsRight: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, (0, _public.reactRouterNavigate)(history, '/add'), {
        fill: true,
        iconType: "plusInCircle",
        "data-test-subj": "remoteClusterCreateButton",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 389,
          columnNumber: 9
        }
      }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.remoteClusters.remoteClusterList.connectButtonLabel",
        defaultMessage: "Add a remote cluster",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 395,
          columnNumber: 11
        }
      })),
      onChange: this.onSearch,
      box: {
        incremental: true,
        'data-test-subj': 'remoteClusterSearch'
      }
    };
    const pagination = {
      initialPageSize: 20,
      pageSizeOptions: [10, 20, 50]
    };
    const selection = {
      onSelectionChange: selectedItems => this.setState({
        selectedItems
      }),
      selectable: ({
        isConfiguredByNode
      }) => !isConfiguredByNode
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
      items: filteredClusters,
      itemId: "name",
      columns: columns,
      search: search,
      pagination: pagination,
      sorting: sorting,
      selection: selection,
      "data-test-subj": "remoteClusterListTable",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 419,
        columnNumber: 7
      }
    });
  }
}
exports.RemoteClusterTable = RemoteClusterTable;
(0, _defineProperty2.default)(RemoteClusterTable, "propTypes", {
  clusters: _propTypes.default.array,
  openDetailPanel: _propTypes.default.func.isRequired
});
(0, _defineProperty2.default)(RemoteClusterTable, "defaultProps", {
  clusters: []
});