"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedQueries = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _list = require("./list");
var _new = require("./new");
var _edit = require("./edit");
var _use_breadcrumbs = require("../../common/hooks/use_breadcrumbs");
var _components = require("../components");
var _kibana = require("../../common/lib/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/routes/saved_queries/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SavedQueriesComponent = () => {
  const permissions = (0, _kibana.useKibana)().services.application.capabilities.osquery;
  (0, _use_breadcrumbs.useBreadcrumbs)('saved_queries');
  const match = (0, _reactRouterDom.useRouteMatch)();
  if (!permissions.readSavedQueries) {
    return /*#__PURE__*/_react.default.createElement(_components.MissingPrivileges, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 25,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${match.url}/new`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 7
    }
  }, permissions.writeSavedQueries ? /*#__PURE__*/_react.default.createElement(_new.NewSavedQueryPage, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 42
    }
  }) : /*#__PURE__*/_react.default.createElement(_components.MissingPrivileges, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 66
    }
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${match.url}/:savedQueryId`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_edit.EditSavedQueryPage, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${match.url}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_list.QueriesPage, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 9
    }
  })));
};
const SavedQueries = exports.SavedQueries = /*#__PURE__*/_react.default.memo(SavedQueriesComponent);