"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToolContextMenu = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _i18n = require("../../../utils/i18n");
var _tools_provider = require("../../../context/tools_provider");
var _use_ui_privileges = require("../../../hooks/use_ui_privileges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/tools/table/tools_table_context_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ToolContextMenu = ({
  tool
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    editTool,
    deleteTool,
    testTool,
    cloneTool,
    viewTool
  } = (0, _tools_provider.useToolsActions)();
  const [isOpen, setIsOpen] = (0, _react2.useState)(false);
  const {
    manageTools
  } = (0, _use_ui_privileges.useUiPrivileges)();
  const editMenuItem = /*#__PURE__*/_react2.default.createElement(_eui.EuiContextMenuItem, {
    icon: "documentEdit",
    key: "edit",
    size: "s",
    onClick: () => {
      editTool(tool.id);
      setIsOpen(false);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 5
    }
  }, _i18n.labels.tools.editToolButtonLabel);
  const deleteMenuItem = /*#__PURE__*/_react2.default.createElement(_eui.EuiContextMenuItem, {
    icon: "trash",
    key: "delete",
    size: "s",
    css: (0, _react.css)`
        color: ${euiTheme.colors.textDanger};
      `,
    onClick: () => {
      deleteTool(tool.id);
      setIsOpen(false);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 5
    }
  }, _i18n.labels.tools.deleteToolButtonLabel);
  const testMenuItem = /*#__PURE__*/_react2.default.createElement(_eui.EuiContextMenuItem, {
    icon: "play",
    key: "test",
    size: "s",
    onClick: () => {
      testTool(tool.id);
      setIsOpen(false);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 5
    }
  }, _i18n.labels.tools.testToolButtonLabel);
  const cloneMenuItem = /*#__PURE__*/_react2.default.createElement(_eui.EuiContextMenuItem, {
    icon: "copy",
    key: "clone",
    size: "s",
    onClick: () => {
      cloneTool(tool.id);
      setIsOpen(false);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 5
    }
  }, _i18n.labels.tools.cloneToolButtonLabel);
  const viewMenuItem = /*#__PURE__*/_react2.default.createElement(_eui.EuiContextMenuItem, {
    icon: "eye",
    key: "view",
    size: "s",
    onClick: () => {
      viewTool(tool.id);
      setIsOpen(false);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 5
    }
  }, _i18n.labels.tools.viewToolButtonLabel);
  const menuItems = !tool.readonly && manageTools ? [editMenuItem, testMenuItem, cloneMenuItem, deleteMenuItem] : [testMenuItem, viewMenuItem];
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiPopover, {
    id: `${tool.id}_context-menu`,
    panelPaddingSize: "s",
    button: /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, {
      iconType: "boxesHorizontal",
      onClick: () => setIsOpen(openState => !openState),
      "aria-label": _i18n.labels.tools.toolContextMenuButtonLabel,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 9
      }
    }),
    isOpen: isOpen,
    closePopover: () => setIsOpen(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: menuItems,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 7
    }
  }));
};
exports.ToolContextMenu = ToolContextMenu;