"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LazyObservabilityPageTemplate = void 0;
exports.ObservabilityPageTemplate = ObservabilityPageTemplate;
exports.createLazyObservabilityPageTemplate = createLazyObservabilityPageTemplate;
exports.default = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _public = require("@kbn/kibana-react-plugin/public");
var _sharedUxErrorBoundary = require("@kbn/shared-ux-error-boundary");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _search_bar_portal = require("./search_bar_portal");
var _nav_name_with_badge = require("./nav_name_with_badge");
var _nav_name_with_beta_badge = require("./nav_name_with_beta_badge");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_shared/public/components/page_template/page_template.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ObservabilityPageTemplate({
  children,
  currentAppId$,
  getUrlForApp,
  navigateToApp,
  navigationSections$,
  showSolutionNav = true,
  isPageDataLoaded = true,
  getPageTemplateServices,
  bottomBar,
  bottomBarProps,
  pageSectionProps,
  topSearchBar,
  ...pageTemplateProps
}) {
  const sections = (0, _useObservable.default)(navigationSections$, []);
  const currentAppId = (0, _useObservable.default)(currentAppId$, undefined);
  const {
    pathname: currentPath
  } = (0, _reactRouterDom.useLocation)();
  const {
    services
  } = (0, _public.useKibana)();
  const sideNavItems = (0, _react.useMemo)(() => sections.map(({
    label,
    entries,
    isBetaFeature
  }, sectionIndex) => ({
    id: `${sectionIndex}`,
    name: isBetaFeature ? /*#__PURE__*/_react.default.createElement(_nav_name_with_beta_badge.NavNameWithBetaBadge, {
      label: label,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 31
      }
    }) : label,
    items: entries.map((entry, entryIndex) => {
      const href = getUrlForApp(entry.app, {
        path: entry.path
      });
      const isSelected = entry.app === currentAppId && (entry.matchPath ? entry.matchPath(currentPath) : (0, _reactRouterDom.matchPath)(currentPath, {
        path: entry.path,
        exact: !!entry.matchFullPath,
        strict: !entry.ignoreTrailingSlash
      }) != null);
      const badgeLocalStorageId = `observability.nav_item_badge_visible_${entry.app}${entry.path}`;
      const navId = entry.label.toLowerCase().split(' ').join('_');
      return {
        id: `${sectionIndex}.${entryIndex}`,
        name: entry.isBetaFeature ? /*#__PURE__*/_react.default.createElement(_nav_name_with_beta_badge.NavNameWithBetaBadge, {
          label: entry.label,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 142,
            columnNumber: 15
          }
        }) : entry.isNewFeature ? /*#__PURE__*/_react.default.createElement(_nav_name_with_badge.NavNameWithBadge, {
          label: entry.label,
          localStorageId: badgeLocalStorageId,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 144,
            columnNumber: 15
          }
        }) : entry.isTechnicalPreview ? /*#__PURE__*/_react.default.createElement(_nav_name_with_beta_badge.NavNameWithBetaBadge, {
          label: entry.label,
          iconType: "beaker",
          isTechnicalPreview: true,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 146,
            columnNumber: 15
          }
        }) : entry.label,
        href,
        isSelected,
        'data-nav-id': navId,
        'data-test-subj': `observability-nav-${entry.app}-${navId}`,
        onClick: event => {
          if (entry.onClick) {
            entry.onClick(event);
          }

          // Hides NEW badge when the item is clicked
          if (entry.isNewFeature) {
            (0, _nav_name_with_badge.hideBadge)(badgeLocalStorageId);
          }
          if (event.button !== 0 || event.defaultPrevented || event.metaKey || event.altKey || event.ctrlKey || event.shiftKey) {
            return;
          }
          event.preventDefault();
          navigateToApp(entry.app, {
            path: entry.path
          });
        }
      };
    })
  })), [currentAppId, currentPath, getUrlForApp, navigateToApp, sections]);
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplateKibanaProvider, (0, _extends2.default)({}, getPageTemplateServices(), {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, (0, _extends2.default)({
    restrictWidth: false
  }, pageTemplateProps, {
    solutionNav: showSolutionNav ? {
      icon: 'logoObservability',
      items: sideNavItems,
      name: sideNavTitle
    } : undefined,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxErrorBoundary.KibanaErrorBoundaryProvider, {
    analytics: services.analytics,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxErrorBoundary.KibanaErrorBoundary, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, (0, _extends2.default)({
    component: "div",
    alignment: pageTemplateProps.isEmptyState ? 'center' : 'top'
  }, pageSectionProps, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 13
    }
  }), topSearchBar && /*#__PURE__*/_react.default.createElement(_search_bar_portal.SearchBarPortal, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 32
    }
  }, topSearchBar), children))), bottomBar && /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.BottomBar, (0, _extends2.default)({}, bottomBarProps, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 11
    }
  }), bottomBar)));
}

// for lazy import
// eslint-disable-next-line import/no-default-export
var _default = exports.default = ObservabilityPageTemplate;
const sideNavTitle = _i18n.i18n.translate('xpack.observabilityShared.pageLayout.sideNavTitle', {
  defaultMessage: 'Observability'
});
const LazyObservabilityPageTemplate = exports.LazyObservabilityPageTemplate = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./page_template'))));
function createLazyObservabilityPageTemplate(injectedDeps) {
  return pageTemplateProps => /*#__PURE__*/_react.default.createElement(_react.default.Suspense, {
    fallback: null,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(LazyObservabilityPageTemplate, (0, _extends2.default)({}, pageTemplateProps, injectedDeps, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 7
    }
  })));
}