"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ALERT_DETAILS_PAGE_ID = void 0;
exports.AlertDetails = AlertDetails;
exports.METRIC_THRESHOLD_ALERT_TYPE_ID = exports.METRIC_INVENTORY_THRESHOLD_ALERT_TYPE_ID = exports.LOG_DOCUMENT_COUNT_RULE_TYPE_ID = void 0;
exports.getScreenDescription = getScreenDescription;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _public = require("@kbn/observability-shared-plugin/public");
var _dedent = _interopRequireDefault(require("dedent"));
var _alert_fields_table = require("@kbn/alerts-ui-shared/src/alert_fields_table");
var _react2 = require("@emotion/react");
var _lodash = require("lodash");
var _ebtTools = require("@kbn/ebt-tools");
var _moment = _interopRequireDefault(require("moment"));
var _obs_cases_context = require("./components/obs_cases_context");
var _related_alerts = require("./components/related_alerts/related_alerts");
var _types = require("./types");
var _components = require("./components");
var _investigation_guide = require("./components/investigation_guide");
var _status_bar = require("./components/status_bar");
var _kibana_react = require("../../utils/kibana_react");
var _use_fetch_rule = require("../../hooks/use_fetch_rule");
var _use_plugin_context = require("../../hooks/use_plugin_context");
var _use_fetch_alert_detail = require("../../hooks/use_fetch_alert_detail");
var _header_actions = require("./components/header_actions");
var _center_justified_spinner = require("../../components/center_justified_spinner");
var _get_time_zone = require("../../utils/get_time_zone");
var _is_alert_details_enabled = require("../../utils/is_alert_details_enabled");
var _paths = require("../../../common/locators/paths");
var _header_menu = require("../overview/components/header_menu/header_menu");
var _alert_overview = require("../../components/alert_overview/alert_overview");
var _alert_details_contextual_insights = require("./alert_details_contextual_insights");
var _alert_history = require("./components/alert_history");
var _stale_alert = _interopRequireDefault(require("./components/stale_alert"));
var _related_dashboards = require("./components/related_dashboards");
var _format_alert_title = require("../../utils/format_alert_title");
var _alert_subtitle = require("./components/alert_subtitle");
var _proximal_alerts_callout = require("./proximal_alerts_callout");
var _use_tab_id = require("./hooks/use_tab_id");
var _use_related_dashboards = require("./hooks/use_related_dashboards");
var _use_alert_details_page_view_ebt = require("../../hooks/use_alert_details_page_view_ebt");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/pages/alert_details/alert_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ALERT_DETAILS_PAGE_ID = exports.ALERT_DETAILS_PAGE_ID = 'alert-details-o11y';
const defaultBreadcrumb = _i18n.i18n.translate('xpack.observability.breadcrumbs.alertDetails', {
  defaultMessage: 'Alert details'
});
const LOG_DOCUMENT_COUNT_RULE_TYPE_ID = exports.LOG_DOCUMENT_COUNT_RULE_TYPE_ID = 'logs.alert.document.count';
const METRIC_THRESHOLD_ALERT_TYPE_ID = exports.METRIC_THRESHOLD_ALERT_TYPE_ID = 'metrics.alert.threshold';
const METRIC_INVENTORY_THRESHOLD_ALERT_TYPE_ID = exports.METRIC_INVENTORY_THRESHOLD_ALERT_TYPE_ID = 'metrics.alert.inventory.threshold';
const isTabId = value => {
  return Object.values(_types.TAB_IDS).includes(value);
};
function AlertDetails() {
  var _rule$artifacts, _rule$artifacts$inves, _rule$artifacts2, _rule$artifacts2$inve, _alertDetail$formatte2, _alertDetail$formatte3;
  const {
    services
  } = (0, _kibana_react.useKibana)();
  const {
    http,
    triggersActionsUi: {
      ruleTypeRegistry
    },
    observabilityAIAssistant,
    uiSettings,
    serverless
  } = services;
  const {
    ObservabilityPageTemplate,
    config
  } = (0, _use_plugin_context.usePluginContext)();
  const {
    alertId
  } = (0, _reactRouterDom.useParams)();
  const {
    getUrlTabId,
    setUrlTabId
  } = (0, _use_tab_id.useTabId)();
  const urlTabId = getUrlTabId();
  const {
    isLoadingRelatedDashboards,
    suggestedDashboards,
    linkedDashboards,
    refetchRelatedDashboards
  } = (0, _use_related_dashboards.useRelatedDashboards)(alertId);
  const [isLoading, alertDetail] = (0, _use_fetch_alert_detail.useFetchAlertDetail)(alertId);
  const [ruleTypeModel, setRuleTypeModel] = (0, _react.useState)(null);
  const ruleId = alertDetail === null || alertDetail === void 0 ? void 0 : alertDetail.formatted.fields[_ruleDataUtils.ALERT_RULE_UUID];
  const {
    rule,
    refetch
  } = (0, _use_fetch_rule.useFetchRule)({
    ruleId: ruleId || ''
  });
  (0, _use_alert_details_page_view_ebt.useAlertDetailsPageViewEbt)({
    ruleType: rule === null || rule === void 0 ? void 0 : rule.ruleTypeId
  });
  const onSuccessAddSuggestedDashboard = (0, _react.useCallback)(async () => {
    await Promise.all([refetchRelatedDashboards(), refetch()]);
  }, [refetch, refetchRelatedDashboards]);

  // used to trigger refetch when rule edit flyout closes
  const onUpdate = (0, _react.useCallback)(() => {
    refetch();
    refetchRelatedDashboards();
  }, [refetch, refetchRelatedDashboards]);
  const [alertStatus, setAlertStatus] = (0, _react.useState)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [sources, setSources] = (0, _react.useState)();
  const [activeTabId, setActiveTabId] = (0, _react.useState)();
  const handleSetTabId = async (tabId, newUrlState) => {
    setActiveTabId(tabId);
    if (newUrlState) {
      setUrlTabId(tabId, true, newUrlState);
    } else {
      setUrlTabId(tabId, true);
    }
  };
  (0, _react.useEffect)(() => {
    if (!alertDetail || !observabilityAIAssistant) {
      return;
    }
    const screenDescription = getScreenDescription(alertDetail);
    return observabilityAIAssistant.service.setScreenContext({
      screenDescription,
      data: [{
        name: 'alert_fields',
        description: 'The fields and values for the alert',
        value: getRelevantAlertFields(alertDetail)
      }]
    });
  }, [observabilityAIAssistant, alertDetail]);
  (0, _react.useEffect)(() => {
    if (alertDetail) {
      var _alertDetail$formatte;
      setRuleTypeModel(ruleTypeRegistry.get(alertDetail === null || alertDetail === void 0 ? void 0 : alertDetail.formatted.fields[_ruleDataUtils.ALERT_RULE_TYPE_ID]));
      setAlertStatus(alertDetail === null || alertDetail === void 0 ? void 0 : (_alertDetail$formatte = alertDetail.formatted) === null || _alertDetail$formatte === void 0 ? void 0 : _alertDetail$formatte.fields[_ruleDataUtils.ALERT_STATUS]);
      setActiveTabId(urlTabId && isTabId(urlTabId) ? urlTabId : 'overview');
    }
  }, [alertDetail, ruleTypeRegistry, urlTabId]);
  (0, _public.useBreadcrumbs)([{
    href: http.basePath.prepend(_paths.paths.observability.alerts),
    text: _i18n.i18n.translate('xpack.observability.breadcrumbs.alertsLinkText', {
      defaultMessage: 'Alerts'
    }),
    deepLinkId: 'observability-overview:alerts'
  }, {
    text: alertDetail ? (0, _format_alert_title.getAlertTitle)(alertDetail.formatted.fields[_ruleDataUtils.ALERT_RULE_CATEGORY]) : defaultBreadcrumb
  }], {
    serverless
  });
  const onUntrackAlert = (0, _react.useCallback)(() => {
    setAlertStatus(_ruleDataUtils.ALERT_STATUS_UNTRACKED);
  }, []);
  const showRelatedAlertsFromCallout = () => {
    handleSetTabId('related_alerts', {
      filterProximal: 'true'
    });
  };
  (0, _ebtTools.usePageReady)({
    isRefreshing: isLoading,
    isReady: !isLoading && !!alertDetail && activeTabId === 'overview',
    meta: {
      description: '[ttfmp_alert_details] The Observability Alert Details overview page has loaded successfully.'
    }
  });

  // This is the time range that will be used to open the dashboards
  // in the related dashboards tab
  const dashboardTimeRange = (0, _react.useMemo)(() => {
    return {
      from: (0, _moment.default)(alertDetail === null || alertDetail === void 0 ? void 0 : alertDetail.formatted.start).subtract(30, 'minutes').toISOString(),
      to: (0, _moment.default)(alertDetail === null || alertDetail === void 0 ? void 0 : alertDetail.formatted.start).add(30, 'minutes').toISOString()
    };
  }, [alertDetail]);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_center_justified_spinner.CenterJustifiedSpinner, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 217,
        columnNumber: 12
      }
    });
  }
  if (!isLoading && !alertDetail) return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "alertDetailsError",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "warning",
    color: "danger",
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 227,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.observability.alertDetails.errorPromptTitle', {
      defaultMessage: 'Unable to load alert details'
    })),
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 234,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.observability.alertDetails.errorPromptBody', {
      defaultMessage: 'There was an error loading the alert details.'
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 9
    }
  }));
  const AlertDetailsAppSection = ruleTypeModel ? ruleTypeModel.alertDetailsAppSection : null;
  const timeZone = (0, _get_time_zone.getTimeZone)(uiSettings);
  const overviewTab = alertDetail ? AlertDetailsAppSection &&
  /*
  when feature flag is enabled, show alert details page with customized overview tab,
  otherwise show default overview tab
  */
  (0, _is_alert_details_enabled.isAlertDetailsEnabledPerApp)(alertDetail.formatted, config) ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_stale_alert.default, {
    alert: alertDetail.formatted,
    alertStatus: alertStatus,
    rule: rule,
    onUntrackAlert: onUntrackAlert,
    refetchRule: refetch,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_proximal_alerts_callout.ProximalAlertsCallout, {
    alertDetail: alertDetail,
    switchTabs: showRelatedAlertsFromCallout,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_components.SourceBar, {
    alert: alertDetail.formatted,
    sources: sources,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 269,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_alert_details_contextual_insights.AlertDetailContextualInsights, {
    alert: alertDetail,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 270,
      columnNumber: 11
    }
  }), rule && alertDetail.formatted && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(AlertDetailsAppSection, {
    alert: alertDetail.formatted,
    rule: rule,
    timeZone: timeZone,
    setSources: setSources,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_alert_history.AlertHistoryChart, {
    alert: alertDetail.formatted,
    rule: rule,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 279,
      columnNumber: 15
    }
  })))) : /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    "data-test-subj": "overviewTabPanel",
    paddingSize: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_proximal_alerts_callout.ProximalAlertsCallout, {
    alertDetail: alertDetail,
    switchTabs: showRelatedAlertsFromCallout,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 290,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_alert_details_contextual_insights.AlertDetailContextualInsights, {
    alert: alertDetail,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 295,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 296,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_alert_overview.AlertOverview, {
    alert: alertDetail.formatted,
    alertStatus: alertStatus,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 297,
      columnNumber: 9
    }
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  const metadataTab = (alertDetail === null || alertDetail === void 0 ? void 0 : alertDetail.raw) && /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    "data-test-subj": "metadataTabPanel",
    paddingSize: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 306,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_alert_fields_table.AlertFieldsTable, {
    alert: alertDetail.raw,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 7
    }
  }));
  const relatedDashboardsTab = alertDetail && rule ? /*#__PURE__*/_react.default.createElement(_related_dashboards.RelatedDashboards, {
    suggestedDashboards: suggestedDashboards,
    linkedDashboards: linkedDashboards,
    isLoadingRelatedDashboards: isLoadingRelatedDashboards,
    rule: rule,
    onSuccessAddSuggestedDashboard: onSuccessAddSuggestedDashboard,
    timeRange: dashboardTimeRange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 7
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 322,
      columnNumber: 7
    }
  });
  const tabs = [{
    id: 'overview',
    name: _i18n.i18n.translate('xpack.observability.alertDetails.tab.overviewLabel', {
      defaultMessage: 'Overview'
    }),
    'data-test-subj': 'overviewTab',
    content: overviewTab
  }, {
    id: 'metadata',
    name: _i18n.i18n.translate('xpack.observability.alertDetails.tab.metadataLabel', {
      defaultMessage: 'Metadata'
    }),
    'data-test-subj': 'metadataTab',
    content: metadataTab
  }, {
    id: 'investigation_guide',
    name: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.observability.alertDetails.tab.investigationGuideLabel",
      defaultMessage: "Investigation guide",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 346,
        columnNumber: 11
      }
    }), (rule === null || rule === void 0 ? void 0 : (_rule$artifacts = rule.artifacts) === null || _rule$artifacts === void 0 ? void 0 : (_rule$artifacts$inves = _rule$artifacts.investigation_guide) === null || _rule$artifacts$inves === void 0 ? void 0 : _rule$artifacts$inves.blob) && /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      color: "success",
      css: {
        marginLeft: '5px'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 351,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "dot",
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 352,
        columnNumber: 15
      }
    }))),
    'data-test-subj': 'investigationGuideTab',
    content: /*#__PURE__*/_react.default.createElement(_investigation_guide.InvestigationGuide, {
      blob: rule === null || rule === void 0 ? void 0 : (_rule$artifacts2 = rule.artifacts) === null || _rule$artifacts2 === void 0 ? void 0 : (_rule$artifacts2$inve = _rule$artifacts2.investigation_guide) === null || _rule$artifacts2$inve === void 0 ? void 0 : _rule$artifacts2$inve.blob,
      onUpdate: onUpdate,
      refetch: refetch,
      rule: rule,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 359,
        columnNumber: 9
      }
    })
  }, {
    id: 'related_alerts',
    name: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.observability.alertDetails.tab.relatedAlertsLabe",
      defaultMessage: "Related alerts",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 371,
        columnNumber: 11
      }
    })),
    'data-test-subj': 'relatedAlertsTab',
    content: /*#__PURE__*/_react.default.createElement(_related_alerts.RelatedAlerts, {
      alertData: alertDetail,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 378,
        columnNumber: 16
      }
    })
  }, {
    id: 'related_dashboards',
    name: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.observability.alertDetails.tab.relatedDashboardsLabel",
      defaultMessage: "Related dashboards",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 384,
        columnNumber: 11
      }
    }), isLoadingRelatedDashboards ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      css: {
        marginLeft: '5px'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 389,
        columnNumber: 13
      }
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      color: "success",
      css: {
        marginLeft: '5px'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 391,
        columnNumber: 13
      }
    }, ((linkedDashboards === null || linkedDashboards === void 0 ? void 0 : linkedDashboards.length) || 0) + ((suggestedDashboards === null || suggestedDashboards === void 0 ? void 0 : suggestedDashboards.length) || 0))),
    'data-test-subj': 'relatedDashboardsTab',
    content: relatedDashboardsTab
  }];
  return /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, {
    pageHeader: {
      pageTitle: alertDetail !== null && alertDetail !== void 0 && alertDetail.formatted ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (0, _format_alert_title.getAlertTitle)(alertDetail.formatted.fields[_ruleDataUtils.ALERT_RULE_CATEGORY]), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "xs",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 408,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react.default.createElement(_alert_subtitle.AlertSubtitle, {
        alert: alertDetail.formatted,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 409,
          columnNumber: 13
        }
      })) : /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 412,
          columnNumber: 11
        }
      }),
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_header_actions.HeaderActions, {
        alert: (_alertDetail$formatte2 = alertDetail === null || alertDetail === void 0 ? void 0 : alertDetail.formatted) !== null && _alertDetail$formatte2 !== void 0 ? _alertDetail$formatte2 : null,
        alertIndex: alertDetail === null || alertDetail === void 0 ? void 0 : alertDetail.raw._index,
        alertStatus: alertStatus,
        onUntrackAlert: onUntrackAlert,
        onUpdate: onUpdate,
        rule: rule,
        refetch: refetch,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 415,
          columnNumber: 11
        }
      })],
      bottomBorder: false,
      'data-test-subj': (rule === null || rule === void 0 ? void 0 : rule.ruleTypeId) || 'alertDetailsPageTitle'
    },
    pageSectionProps: {
      paddingSize: 'none',
      css: (0, _react2.css)`
          padding: 0 ${euiTheme.size.l} ${euiTheme.size.l} ${euiTheme.size.l};
        `
    },
    "data-test-subj": "alertDetails",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 403,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_obs_cases_context.ObsCasesContext, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 436,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_status_bar.StatusBar, {
    alert: (_alertDetail$formatte3 = alertDetail === null || alertDetail === void 0 ? void 0 : alertDetail.formatted) !== null && _alertDetail$formatte3 !== void 0 ? _alertDetail$formatte3 : null,
    alertStatus: alertStatus,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 437,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 438,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_header_menu.HeaderMenu, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 439,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    "data-test-subj": "alertDetailsTabbedContent",
    tabs: tabs,
    selectedTab: tabs.find(tab => tab.id === activeTabId),
    onTabClick: tab => handleSetTabId(tab.id),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 440,
      columnNumber: 9
    }
  })));
}
function getScreenDescription(alertDetail) {
  const alertState = alertDetail.formatted.active ? 'active' : 'recovered';
  const alertStarted = new Date(alertDetail.formatted.start).toISOString();
  const alertUpdated = new Date(alertDetail.formatted.lastUpdated).toISOString();
  return (0, _dedent.default)(`The user is looking at an ${alertState} alert. It started at ${alertStarted}, and was last updated at ${alertUpdated}.

  ${alertDetail.formatted.reason ? `The reason given for the alert is ${alertDetail.formatted.reason}.` : ''}

  Use the following alert fields as background information for generating a response. Do not list them as bullet points in the response.
  ${Object.entries(getRelevantAlertFields(alertDetail)).map(([key, value]) => `${key}: ${JSON.stringify(value)}`).join('\n')}
  `);
}
function getRelevantAlertFields(alertDetail) {
  return (0, _lodash.omit)(alertDetail.formatted.fields, ['kibana.alert.rule.revision', 'kibana.alert.rule.execution.uuid', 'kibana.alert.flapping_history', 'kibana.alert.uuid', 'kibana.alert.rule.uuid', 'event.action', 'event.kind', 'kibana.alert.rule.tags', 'kibana.alert.maintenance_window_ids', 'kibana.alert.consecutive_matches']);
}