"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewRectAnnotation = NewRectAnnotation;
exports.ObsRectAnnotation = ObsRectAnnotation;
var _charts = require("@elastic/charts");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _moment = _interopRequireDefault(require("moment"));
var _reactHookForm = require("react-hook-form");
var _lodash = require("lodash");
var _annotation_tooltip = require("./annotation_tooltip");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/components/annotations/components/new_rect_annotation.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function NewRectAnnotation({
  slo,
  isCreateOpen
}) {
  const {
    watch,
    getValues
  } = (0, _reactHookForm.useFormContext)();
  const timestamp = watch('@timestamp');
  const eventEnd = watch('event.end');
  if (!timestamp || !eventEnd || !isCreateOpen) {
    return null;
  }
  const values = getValues();
  const annotationStyle = watch('annotation.style');
  const annotationType = watch('annotation.type');
  return /*#__PURE__*/_react.default.createElement(ObsRectAnnotation, {
    annotation: (0, _lodash.cloneDeep)({
      ...values,
      annotation: {
        ...values.annotation,
        style: annotationStyle,
        type: annotationType
      },
      ...(slo ? {
        slo: {
          id: slo.id,
          instanceId: slo.instanceId
        }
      } : {})
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  });
}
function ObsRectAnnotation({
  annotation
}) {
  var _annotation$event, _annotation$annotatio, _annotationStyle$colo, _annotationStyle$rect;
  const message = annotation.message;
  const timestamp = annotation['@timestamp'];
  const timestampEnd = (_annotation$event = annotation.event) === null || _annotation$event === void 0 ? void 0 : _annotation$event.end;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const annotationStyle = (_annotation$annotatio = annotation.annotation) === null || _annotation$annotatio === void 0 ? void 0 : _annotation$annotatio.style;
  const color = (_annotationStyle$colo = annotationStyle === null || annotationStyle === void 0 ? void 0 : annotationStyle.color) !== null && _annotationStyle$colo !== void 0 ? _annotationStyle$colo : euiTheme.colors.warning;
  return /*#__PURE__*/_react.default.createElement(_charts.RectAnnotation, {
    dataValues: [{
      coordinates: {
        x0: (0, _moment.default)(timestamp).valueOf(),
        x1: (0, _moment.default)(timestampEnd).valueOf()
      },
      details: message
    }],
    id: 'id' in annotation ? annotation.id : `${timestamp}${message}`,
    style: {
      fill: color,
      opacity: 1
    },
    outside: (annotationStyle === null || annotationStyle === void 0 ? void 0 : (_annotationStyle$rect = annotationStyle.rect) === null || _annotationStyle$rect === void 0 ? void 0 : _annotationStyle$rect.fill) === 'outside',
    outsideDimension: 14,
    customTooltip: () => /*#__PURE__*/_react.default.createElement(_annotation_tooltip.AnnotationTooltip, {
      annotation: annotation,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 28
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 5
    }
  });
}