"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteAnnotationsModal = DeleteAnnotationsModal;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/components/annotations/components/common/delete_annotations_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function DeleteAnnotationsModal({
  isDeleteModalVisible,
  onDelete,
  setSelection,
  setIsDeleteModalVisible,
  selection
}) {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  if (!isDeleteModalVisible) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, " ");
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    title: _i18n.i18n.translate('xpack.observability.deleteAnnotations.euiConfirmModal.deleteAnnotationLabel', {
      defaultMessage: 'Delete annotation'
    }),
    titleProps: {
      id: modalTitleId
    },
    onCancel: () => {
      setIsDeleteModalVisible(false);
      setSelection([]);
    },
    onConfirm: onDelete,
    cancelButtonText: _i18n.i18n.translate('xpack.observability.deleteAnnotations.euiConfirmModal.cancelButtonLabel', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.observability.deleteAnnotations.euiConfirmModal.deleteButtonLabel', {
      defaultMessage: 'Delete'
    }),
    buttonColor: "danger",
    defaultFocusedButton: "confirm",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.observability.deleteAnnotations.euiConfirmModal.deleteAnnotationDescription', {
    defaultMessage: 'Are you sure you want to delete "{names}" annotation?',
    values: {
      names: selection.map(annotation => {
        var _annotation$annotatio;
        return (_annotation$annotatio = annotation.annotation.title) !== null && _annotation$annotatio !== void 0 ? _annotation$annotatio : annotation.message;
      }).join(', ')
    }
  })));
}