"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimestampTooltip = TimestampTooltip;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _datetime = require("../../../../common/utils/formatters/datetime");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/components/alerts_table/common/timestamp_tooltip.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function TimestampTooltip({
  time,
  timeUnit = 'milliseconds'
}) {
  const absoluteTimeLabel = (0, _datetime.asAbsoluteDateTime)(time, timeUnit);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: absoluteTimeLabel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    tabIndex: 0,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 7
    }
  }, absoluteTimeLabel));
}