"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNTRACKED_ALERTS = exports.RECOVERED_ALERTS = exports.EMPTY_FILTERS = exports.DEFAULT_QUERY_STRING = exports.ALL_ALERTS = exports.ALERT_STATUS_QUERY = exports.ALERT_STATUS_FILTER = exports.ACTIVE_ALERTS = void 0;
var _i18n = require("@kbn/i18n");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EMPTY_FILTERS = exports.EMPTY_FILTERS = [];
const DEFAULT_QUERY_STRING = exports.DEFAULT_QUERY_STRING = '';
const ALL_ALERTS = exports.ALL_ALERTS = {
  status: _constants.ALERT_STATUS_ALL,
  query: '',
  filter: [],
  label: _i18n.i18n.translate('xpack.observability.alerts.alertStatusFilter.showAll', {
    defaultMessage: 'Show all'
  })
};
const ACTIVE_ALERTS = exports.ACTIVE_ALERTS = {
  status: _ruleDataUtils.ALERT_STATUS_ACTIVE,
  query: `${_ruleDataUtils.ALERT_STATUS}: "${_ruleDataUtils.ALERT_STATUS_ACTIVE}"`,
  filter: [{
    query: {
      match_phrase: {
        [_ruleDataUtils.ALERT_STATUS]: _ruleDataUtils.ALERT_STATUS_ACTIVE
      }
    },
    meta: {}
  }],
  label: _i18n.i18n.translate('xpack.observability.alerts.alertStatusFilter.active', {
    defaultMessage: 'Active'
  })
};
const RECOVERED_ALERTS = exports.RECOVERED_ALERTS = {
  status: _ruleDataUtils.ALERT_STATUS_RECOVERED,
  query: `${_ruleDataUtils.ALERT_STATUS}: "${_ruleDataUtils.ALERT_STATUS_RECOVERED}"`,
  filter: [{
    query: {
      match_phrase: {
        [_ruleDataUtils.ALERT_STATUS]: _ruleDataUtils.ALERT_STATUS_RECOVERED
      }
    },
    meta: {}
  }],
  label: _i18n.i18n.translate('xpack.observability.alerts.alertStatusFilter.recovered', {
    defaultMessage: 'Recovered'
  })
};
const UNTRACKED_ALERTS = exports.UNTRACKED_ALERTS = {
  status: _ruleDataUtils.ALERT_STATUS_UNTRACKED,
  query: `${_ruleDataUtils.ALERT_STATUS}: "${_ruleDataUtils.ALERT_STATUS_UNTRACKED}"`,
  filter: [{
    query: {
      match_phrase: {
        [_ruleDataUtils.ALERT_STATUS]: _ruleDataUtils.ALERT_STATUS_UNTRACKED
      }
    },
    meta: {}
  }],
  label: _i18n.i18n.translate('xpack.observability.alerts.alertStatusFilter.untracked', {
    defaultMessage: 'Untracked'
  })
};
const ALERT_STATUS_QUERY = exports.ALERT_STATUS_QUERY = {
  [ACTIVE_ALERTS.status]: ACTIVE_ALERTS.query,
  [RECOVERED_ALERTS.status]: RECOVERED_ALERTS.query,
  [UNTRACKED_ALERTS.status]: UNTRACKED_ALERTS.query
};
const ALERT_STATUS_FILTER = exports.ALERT_STATUS_FILTER = {
  [ACTIVE_ALERTS.status]: ACTIVE_ALERTS.filter,
  [RECOVERED_ALERTS.status]: RECOVERED_ALERTS.filter,
  [UNTRACKED_ALERTS.status]: UNTRACKED_ALERTS.filter
};