"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityOnboardingHeaderActionMenu = ObservabilityOnboardingHeaderActionMenu;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _common = require("@kbn/observability-shared-plugin/common");
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_onboarding/public/application/shared/header_action_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ObservabilityOnboardingHeaderActionMenu({
  setHeaderActionMenu,
  theme$
}) {
  const {
    services: {
      context
    }
  } = (0, _public.useKibana)();
  const location = (0, _reactRouterDom.useLocation)();
  const normalizedPathname = location.pathname.replace(/\/$/, '');
  const isRootPage = normalizedPathname === '';
  const feedbackButtonLabel = _i18n.i18n.translate('xpack.observability_onboarding.header.feedback', {
    defaultMessage: 'Give feedback'
  });
  if (!context.isServerless && !isRootPage) {
    return /*#__PURE__*/_react.default.createElement(_public2.HeaderMenuPortal, {
      setHeaderActionMenu: setHeaderActionMenu,
      theme$: theme$,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "observabilityOnboardingPageGiveFeedback",
      "aria-label": feedbackButtonLabel,
      href: _common.LOGS_ONBOARDING_FEEDBACK_LINK,
      size: "s",
      iconType: "popout",
      iconSide: "right",
      target: "_blank",
      color: "primary",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 9
      }
    }, feedbackButtonLabel));
  }
  return null;
}