"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopNavMenuItems = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _top_nav_menu_item = require("./top_nav_menu_item");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/navigation/public/top_nav_menu/top_nav_menu_items.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const POPOVER_BREAKPOINTS = ['xs', 's'];
const TopNavMenuItems = ({
  config,
  className,
  popoverBreakpoints = POPOVER_BREAKPOINTS,
  gutterSize = 'xs'
}) => {
  const isMobileMenu = (0, _eui.useIsWithinBreakpoints)(popoverBreakpoints);
  if (!config || config.length === 0) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLinks, {
    "data-test-subj": "top-nav",
    gutterSize: gutterSize,
    className: className,
    popoverBreakpoints: popoverBreakpoints,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  }, closePopover => config.map((menuItem, i) => {
    return /*#__PURE__*/_react.default.createElement(_top_nav_menu_item.TopNavMenuItem, (0, _extends2.default)({
      key: `nav-menu-${i}`,
      isMobileMenu: isMobileMenu,
      closePopover: closePopover
    }, menuItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 13
      }
    }));
  }));
};
exports.TopNavMenuItems = TopNavMenuItems;