"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Status = Status;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _format_number = require("../../../lib/format_number");
var _summary_status = require("../../summary_status");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/enterprise_search/overview/status.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function Status({
  stats
}) {
  const metrics = [{
    label: _i18n.i18n.translate('xpack.monitoring.entSearch.overview.instances', {
      defaultMessage: 'Instances'
    }),
    value: (0, _format_number.formatMetric)(stats.totalInstances, 'int_commas'),
    'data-test-subj': 'totalInstances'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.entSearch.overview.appSearchEngines', {
      defaultMessage: 'App Search Engines'
    }),
    value: (0, _format_number.formatMetric)(stats.appSearchEngines, 'int_commas'),
    'data-test-subj': 'appSearchEngines'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.entSearch.overview.workplaceSearchOrgSources', {
      defaultMessage: 'Org Content Sources'
    }),
    value: (0, _format_number.formatMetric)(stats.workplaceSearchOrgSources, 'int_commas'),
    'data-test-subj': 'workplaceSearchOrgSources'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.entSearch.overview.workplaceSearchPrivateSources', {
      defaultMessage: 'Private Content Sources'
    }),
    value: (0, _format_number.formatMetric)(stats.workplaceSearchPrivateSources, 'int_commas'),
    'data-test-subj': 'workplaceSearchPrivateSources'
  }];
  return /*#__PURE__*/_react.default.createElement(_summary_status.SummaryStatus, {
    metrics: metrics,
    "data-test-subj": "entSearchSummaryStatus",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 10
    }
  });
}