"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertParamPercentage = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/alerts/flyout_expressions/alert_param_percentage.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AlertParamPercentage = props => {
  const {
    name,
    label,
    setRuleParams,
    errors
  } = props;
  const [value, setValue] = _react.default.useState(props.percentage);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    error: errors,
    isInvalid: errors.length > 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    isInvalid: errors.length > 0,
    compressed: true,
    value: value,
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 29,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 30,
        columnNumber: 13
      }
    }, "%")),
    onChange: e => {
      let newValue = parseInt(e.target.value, 10);
      if (isNaN(newValue)) {
        newValue = 0;
      }
      setValue(newValue);
      setRuleParams(name, newValue);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 7
    }
  }));
};
exports.AlertParamPercentage = AlertParamPercentage;