"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsCallout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _replace_tokens = require("./lib/replace_tokens");
var _setup_mode = require("../lib/setup_mode");
var _setup_mode_context = require("../components/setup_mode/setup_mode_context");
var _configuration = require("./configuration");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/alerts/callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AlertsCallout = props => {
  const {
    alerts
  } = props;
  const inSetupMode = (0, _setup_mode.isInSetupMode)(_react.default.useContext(_setup_mode_context.SetupModeContext));
  if (inSetupMode) {
    return null;
  }
  // get a list of each alert state for each rule
  const list = Object.values(alerts).flat().map(alert => alert.states.map(state => ({
    alert,
    state
  }))).flat();
  if (list.length === 0) {
    return null;
  }
  const accordions = list.map((status, index) => {
    const buttonContent = /*#__PURE__*/_react.default.createElement("div", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      responsive: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "warning",
      size: "m",
      color: "danger",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "danger",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 13
      }
    }, (0, _replace_tokens.replaceTokens)(status.state.state.ui.message)))));
    const {
      code
    } = status.state.state.ui.message;
    const accordion = /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
      id: `monitoringAlertCallout_${index}`,
      buttonContent: buttonContent,
      paddingSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 7
      }
    }, code !== null && code !== void 0 && code.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      fontSize: "s",
      paddingSize: "s",
      language: "json",
      isCopyable: true,
      overflowHeight: 300,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 11
      }
    }, code) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
      flush: true,
      bordered: true,
      gutterSize: "m",
      size: "xs",
      style: {
        marginTop: '0.5rem',
        paddingTop: '0.5rem',
        paddingBottom: '0.5rem',
        paddingLeft: `0.5rem`
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 9
      }
    }, (status.state.state.ui.message.nextSteps || []).map((step, stepIndex) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
        onClick: () => {},
        label: (0, _replace_tokens.replaceTokens)(step),
        key: index + stepIndex,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 97,
          columnNumber: 17
        }
      });
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
      label: /*#__PURE__*/_react.default.createElement(_configuration.AlertConfiguration, {
        alert: status.alert.sanitizedRule,
        key: index,
        compressed: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 106,
          columnNumber: 20
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 11
      }
    })));
    const spacer = index !== list.length - 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 48
      }
    }) : null;
    return /*#__PURE__*/_react.default.createElement("div", {
      key: index,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 7
      }
    }, accordion, spacer);
  });
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 7
    }
  }, accordions), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 7
    }
  }));
};
exports.AlertsCallout = AlertsCallout;