"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MAX_ANOMALY_CHARTS_ALLOWED = exports.AnomalyChartsInitializer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _anomaly_explorer_charts_service = require("../../application/services/anomaly_explorer_charts_service");
var _job_selector = require("../../alerting/job_selector");
var _locator = require("../../../common/constants/locator");
var _utils = require("./utils");
var _kibana = require("../../application/contexts/kibana");
var _utils2 = require("../utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/embeddables/anomaly_charts/anomaly_charts_initializer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MAX_ANOMALY_CHARTS_ALLOWED = exports.MAX_ANOMALY_CHARTS_ALLOWED = 50;
const AnomalyChartsInitializer = ({
  initialInput,
  onCreate,
  onCancel,
  adJobsApiService
}) => {
  var _initialInput$title, _initialInput$maxSeri, _initialInput$jobIds;
  const titleManuallyChanged = (0, _react.useRef)(!!(initialInput !== null && initialInput !== void 0 && initialInput.title));
  const [panelTitle, setPanelTitle] = (0, _react.useState)((_initialInput$title = initialInput === null || initialInput === void 0 ? void 0 : initialInput.title) !== null && _initialInput$title !== void 0 ? _initialInput$title : '');
  const [maxSeriesToPlot, setMaxSeriesToPlot] = (0, _react.useState)((_initialInput$maxSeri = initialInput === null || initialInput === void 0 ? void 0 : initialInput.maxSeriesToPlot) !== null && _initialInput$maxSeri !== void 0 ? _initialInput$maxSeri : _anomaly_explorer_charts_service.DEFAULT_MAX_SERIES_TO_PLOT);
  const isPanelTitleValid = (panelTitle === null || panelTitle === void 0 ? void 0 : panelTitle.length) > 0;
  const isMaxSeriesToPlotValid = maxSeriesToPlot >= 1 && maxSeriesToPlot <= MAX_ANOMALY_CHARTS_ALLOWED;
  const newJobUrl = (0, _kibana.useMlLink)({
    page: _locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB
  });
  const [jobIds, setJobIds] = (0, _react.useState)((_initialInput$jobIds = initialInput === null || initialInput === void 0 ? void 0 : initialInput.jobIds) !== null && _initialInput$jobIds !== void 0 ? _initialInput$jobIds : []);
  const jobIdsErrors = (0, _utils2.getJobSelectionErrors)(jobIds);
  const isFormValid = isPanelTitleValid && isMaxSeriesToPlotValid && jobIdsErrors === undefined;
  (0, _react.useEffect)(function updateDefaultTitle() {
    if (!titleManuallyChanged.current) {
      setPanelTitle((0, _utils.getDefaultExplorerChartsPanelTitle)(jobIds));
    }
  }, [initialInput === null || initialInput === void 0 ? void 0 : initialInput.title, jobIds]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.anomalyChartsEmbeddable.setupModal.title",
    defaultMessage: "Anomaly explorer charts configuration",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_job_selector.JobSelectorControl, {
    createJobUrl: newJobUrl,
    multiSelect: true,
    jobsAndGroupIds: jobIds,
    adJobsApiService: adJobsApiService,
    onChange: update => {
      var _update$jobIds, _update$groupIds;
      setJobIds([...((_update$jobIds = update === null || update === void 0 ? void 0 : update.jobIds) !== null && _update$jobIds !== void 0 ? _update$jobIds : []), ...((_update$groupIds = update === null || update === void 0 ? void 0 : update.groupIds) !== null && _update$groupIds !== void 0 ? _update$groupIds : [])]);
    },
    errors: jobIdsErrors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 9
    }
  }), jobIds.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.anomalyChartsEmbeddable.panelTitleLabel",
      defaultMessage: "Panel title",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 17
      }
    }),
    isInvalid: !isPanelTitleValid,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "panelTitleInput",
    id: "panelTitle",
    name: "panelTitle",
    value: panelTitle,
    onChange: e => {
      titleManuallyChanged.current = true;
      setPanelTitle(e.target.value);
    },
    isInvalid: !isPanelTitleValid,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isInvalid: !isMaxSeriesToPlotValid,
    error: !isMaxSeriesToPlotValid ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.anomalyChartsEmbeddable.maxSeriesToPlotError",
      defaultMessage: "Maximum number of series to plot must be between 1 and 50.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 19
      }
    }) : undefined,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.anomalyChartsEmbeddable.maxSeriesToPlotLabel",
      defaultMessage: "Maximum number of series to plot",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 17
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    isInvalid: !isMaxSeriesToPlotValid,
    "data-test-subj": "mlAnomalyChartsInitializerMaxSeries",
    id: "selectMaxSeriesToPlot",
    name: "selectMaxSeriesToPlot",
    value: maxSeriesToPlot,
    onChange: e => setMaxSeriesToPlot(parseInt(e.target.value, 10)),
    min: 1,
    max: MAX_ANOMALY_CHARTS_ALLOWED,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 15
    }
  }))) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: 'spaceBetween',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onCancel,
    "data-test-subj": "mlAnomalyChartsInitializerCancelButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.anomalyChartsEmbeddable.setupModal.cancelButtonLabel",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "mlAnomalyChartsInitializerConfirmButton",
    isDisabled: !isFormValid,
    onClick: onCreate.bind(null, {
      title: panelTitle,
      maxSeriesToPlot,
      jobIds
    }),
    fill: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.anomalyChartsEmbeddable.setupFlyout.confirmButtonLabel",
    defaultMessage: "Confirm",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 13
    }
  })))));
};
exports.AnomalyChartsInitializer = AnomalyChartsInitializer;