"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InferenceInputFormIndexControls = void 0;
exports.useIndexInput = useIndexInput;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _eui = require("@elastic/eui");
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _i18n = require("@kbn/i18n");
var _create_data_view_button = require("../../../components/create_data_view_button");
var _kibana = require("../../../contexts/kibana");
var _inference_base = require("./inference_base");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/model_management/test_models/models/index_input.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const InferenceInputFormIndexControls = ({
  inferrer,
  data,
  disableIndexSelection
}) => {
  var _dataViewListItems$fi;
  const {
    dataViewListItems,
    fieldNames,
    selectedDataViewId,
    setSelectedDataViewId,
    selectedField,
    setSelectedField,
    setDataViewListItems
  } = data;
  const runningState = (0, _useObservable.default)(inferrer.getRunningState$(), inferrer.getRunningState());
  const pipeline = (0, _useObservable.default)(inferrer.getPipeline$(), inferrer.getPipeline());
  const inputComponent = (0, _react.useMemo)(() => inferrer.getInputComponent(), [inferrer]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: 's',
    justifyContent: 'spaceBetween',
    alignItems: 'flexEnd',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.testModelsFlyout.dataViewTitle",
      defaultMessage: "Data view",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 15
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 11
    }
  }, disableIndexSelection ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 17
    }
  }, (_dataViewListItems$fi = dataViewListItems.find(item => item.value === selectedDataViewId)) === null || _dataViewListItems$fi === void 0 ? void 0 : _dataViewListItems$fi.text)) : /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: dataViewListItems,
    value: selectedDataViewId,
    onChange: e => {
      inferrer.setSelectedDataViewId(e.target.value);
      setSelectedDataViewId(e.target.value);
    },
    hasNoInitialSelection: true,
    disabled: runningState === _inference_base.RUNNING_STATE.RUNNING,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_create_data_view_button.CreateDataViewButton, {
    allowAdHocDataView: true,
    onDataViewCreated: dataView => {
      setDataViewListItems(prev => {
        return [...prev, {
          text: dataView.getIndexPattern(),
          value: dataView.id
        }].sort((a, b) => a.text.localeCompare(b.text));
      });
      setSelectedDataViewId(dataView.id);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.trainedModels.testModelsFlyout.indexInput.fieldInput', {
      defaultMessage: 'Field'
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: fieldNames,
    value: selectedField,
    onChange: e => {
      setSelectedField(e.target.value);
    },
    hasNoInitialSelection: true,
    disabled: runningState === _inference_base.RUNNING_STATE.RUNNING,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, inputComponent), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: 'simpleAccordionId',
    buttonContent: _i18n.i18n.translate('xpack.ml.trainedModels.testModelsFlyout.indexInput.viewPipeline', {
      defaultMessage: 'View pipeline'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    fontSize: "s",
    paddingSize: "s",
    lineNumbers: true,
    isCopyable: true,
    overflowHeight: 300,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 9
    }
  }, JSON.stringify(pipeline, null, 2))));
};
exports.InferenceInputFormIndexControls = InferenceInputFormIndexControls;
function useIndexInput({
  inferrer,
  defaultSelectedDataViewId
}) {
  const {
    services: {
      data: {
        dataViews,
        search: {
          search
        }
      }
    }
  } = (0, _kibana.useMlKibana)();
  const [dataViewListItems, setDataViewListItems] = (0, _react.useState)([]);
  const [selectedDataViewId, setSelectedDataViewId] = (0, _react.useState)(defaultSelectedDataViewId);
  const [selectedDataView, setSelectedDataView] = (0, _react.useState)(null);
  const [fieldNames, setFieldNames] = (0, _react.useState)([]);
  const selectedField = (0, _useObservable.default)(inferrer.getInputField$(), inferrer.getInputField());
  const setSelectedField = (0, _react.useCallback)(fieldName => inferrer.setInputField(fieldName), [inferrer]);
  (0, _react.useEffect)(function loadDataViewListItems() {
    async function getFilteredDataViewListItems() {
      const dataViewIds = await dataViews.getIdsWithTitle();
      const supportedFieldTypes = inferrer.getSupportedFieldTypes();
      const hasTextField = async ({
        id
      }) => {
        const dataView = await dataViews.get(id);
        return dataView.fields.getAll().some(dvField => supportedFieldTypes.some(esType => {
          var _dvField$esTypes;
          return (_dvField$esTypes = dvField.esTypes) === null || _dvField$esTypes === void 0 ? void 0 : _dvField$esTypes.includes(esType);
        }));
      };
      const allPromises = dataViewIds.map(hasTextField);
      const resolvedPromises = await Promise.all(allPromises);
      const filteredDataViews = dataViewIds.filter((value, index) => resolvedPromises[index]);
      setDataViewListItems(filteredDataViews.sort((a, b) => a.title.localeCompare(b.title)).map(({
        id,
        title
      }) => ({
        text: title,
        value: id
      })));
    }
    getFilteredDataViewListItems();
  }, [dataViews, inferrer]);
  (0, _react.useEffect)(function loadSelectedDataView() {
    inferrer.reset();
    setFieldNames([]);
    if (selectedDataViewId !== undefined) {
      dataViews.get(selectedDataViewId).then(dv => setSelectedDataView(dv));
    }
  }, [selectedDataViewId, dataViews, inferrer]);
  const loadExamples = (0, _react.useCallback)(() => {
    inferrer.setInputText([]);
    if (selectedField !== undefined && selectedDataView !== null) {
      (0, _rxjs.firstValueFrom)(search({
        params: {
          index: selectedDataView.getIndexPattern(),
          body: {
            fields: [selectedField],
            query: {
              function_score: {
                functions: [{
                  random_score: {}
                }]
              }
            }
          }
        }
      })).then(resp => {
        const tempExamples = resp.rawResponse.hits.hits.filter(({
          fields
        }) => (0, _mlIsPopulatedObject.isPopulatedObject)(fields, [selectedField])).map(({
          fields
        }) => fields[selectedField][0]);
        inferrer.setInputText(tempExamples);
      });
    }
  }, [inferrer, selectedDataView, search, selectedField]);
  (0, _react.useEffect)(function loadFieldNames() {
    if (selectedDataView !== null) {
      const tempFieldNames = selectedDataView.fields.filter(({
        displayName,
        esTypes
      }) => esTypes && esTypes.includes('text') && !['_id', '_index'].includes(displayName)).sort((a, b) => a.displayName.localeCompare(b.displayName)).map(({
        displayName
      }) => ({
        value: displayName,
        text: displayName
      }));
      setFieldNames(tempFieldNames);
      const defaultSelectedField = inferrer.getInputField();
      const fieldName = defaultSelectedField && tempFieldNames.find(field => field.value === defaultSelectedField) ? defaultSelectedField : tempFieldNames[0].value;
      // Only set a field if it's the default field
      // if (inferrer.getInputField() === DEFAULT_INPUT_FIELD) {
      inferrer.setInputField(fieldName);
      // }
    }
  }, [selectedDataView, inferrer] // defaultSelectedField
  );
  (0, _react.useEffect)(function loadExamplesAfterFieldChange() {
    loadExamples();
  },
  // only load examples if selectedField changes
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [selectedField]);
  function reloadExamples() {
    inferrer.reset();
    loadExamples();
  }
  return {
    fieldNames,
    dataViewListItems,
    reloadExamples,
    selectedDataViewId,
    setSelectedDataViewId,
    selectedField,
    setSelectedField,
    setDataViewListItems
  };
}