"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyDetectionJobIdLink = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _kibana = require("../../../../contexts/kibana");
var _locator = require("../../../../../../common/constants/locator");
var _job_group = require("../job_group");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/jobs_list/components/jobs_list/job_id_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// @ts-ignore
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function isGroupIdLink(props) {
  return props.groupId !== undefined;
}
const AnomalyDetectionJobIdLink = props => {
  const mlLocator = (0, _kibana.useMlLocator)();
  const [href, setHref] = (0, _react.useState)('');
  (0, _react.useEffect)(() => {
    let isCancelled = false;
    const generateLink = async () => {
      const pageState = {};
      if (isGroupIdLink(props)) {
        pageState.groupIds = [props.groupId];
      } else {
        pageState.jobId = props.id;
      }
      if (mlLocator) {
        const url = await mlLocator.getUrl({
          page: _locator.ML_PAGES.ANOMALY_DETECTION_JOBS_MANAGE,
          // TODO: Fix this any.
          pageState: pageState
        });
        if (!isCancelled) {
          setHref(url);
        }
      }
    };
    generateLink();
    return () => {
      isCancelled = true;
    };
  }, [props, mlLocator]);
  if (isGroupIdLink(props)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      key: props.groupId,
      href: href,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_job_group.JobGroup, {
      name: props.groupId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 9
      }
    }));
  } else {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      key: props.id,
      href: href,
      css: {
        overflow: 'hidden',
        textOverflow: 'ellipsis'
      },
      title: props.id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 7
      }
    }, props.id);
  }
};
exports.AnomalyDetectionJobIdLink = AnomalyDetectionJobIdLink;