"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScopeSection = ScopeSection;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _scope_expression = require("./scope_expression");
var _check_capabilities = require("../../capabilities/check_capabilities");
var _utils = require("./utils");
var _i18nReact = require("@kbn/i18n-react");
var _locator = require("../../../../common/constants/locator");
var _management = require("../../management");
var _use_create_url = require("../../contexts/kibana/use_create_url");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/rule_editor/scope_section.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * React component for rendering the form fields for editing the scope section of a rule.
 */
function NoFilterListsCallOut() {
  const redirectToFilterManagementPage = (0, _use_create_url.useCreateAndNavigateToManagementMlLink)(_locator.ML_PAGES.FILTER_LISTS_MANAGE, _management.MANAGEMENT_SECTION_IDS.AD_SETTINGS);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.ruleEditor.scopeSection.noFilterListsConfiguredTitle",
      defaultMessage: "No filter lists configured",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 9
      }
    }),
    iconType: "gear",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.ruleEditor.scopeSection.createFilterListsDescription",
    defaultMessage: "To configure scope, you must first use the\xA0{filterListsLink} settings page to create the list of values you want to include or exclude in the job rule.",
    values: {
      filterListsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: redirectToFilterManagementPage,
        "data-test-subj": "mlScopeNoFilterListsLink",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 48,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.ruleEditor.scopeSection.createFilterListsDescription.filterListsLinkText",
        defaultMessage: "Filter Lists",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 52,
          columnNumber: 17
        }
      }))
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 9
    }
  })));
}
function NoPermissionCallOut() {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.ruleEditor.scopeSection.noPermissionToViewFilterListsTitle",
      defaultMessage: "You do not have permission to view filter lists",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 9
      }
    }),
    iconType: "gear",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  });
}
function ScopeSection({
  isEnabled,
  onEnabledChange,
  partitioningFieldNames,
  filterListIds,
  scope,
  updateScope
}) {
  const canGetFilters = (0, _check_capabilities.checkPermission)('canGetFilters');
  if (partitioningFieldNames === null || partitioningFieldNames.length === 0) {
    return null;
  }
  let content;
  if (filterListIds.length > 0) {
    content = partitioningFieldNames.map((fieldName, index) => {
      let filterValues;
      if (scope !== undefined && scope[fieldName] !== undefined) {
        filterValues = scope[fieldName];
      } else {
        filterValues = (0, _utils.getScopeFieldDefaults)(filterListIds);
      }
      return /*#__PURE__*/_react.default.createElement(_scope_expression.ScopeExpression, {
        key: index,
        fieldName: fieldName,
        filterId: filterValues.filter_id,
        filterType: filterValues.filter_type,
        enabled: filterValues.enabled,
        filterListIds: filterListIds,
        updateScope: updateScope,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 104,
          columnNumber: 9
        }
      });
    });
  } else if (canGetFilters === false) {
    content = /*#__PURE__*/_react.default.createElement(NoPermissionCallOut, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 15
      }
    });
  } else {
    content = /*#__PURE__*/_react.default.createElement(NoFilterListsCallOut, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 15
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.ruleEditor.scopeSection.scopeTitle",
    defaultMessage: "Scope",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "enable_scope_checkbox",
    "data-test-subj": "mlScopeEnableCheckbox",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.ruleEditor.scopeSection.addFilterListLabel",
      defaultMessage: "Add a filter list to limit where the job rule applies.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 11
      }
    }),
    checked: isEnabled,
    onChange: onEnabledChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 7
    }
  }), isEnabled && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 21
    }
  }, content), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 7
    }
  }));
}
ScopeSection.propTypes = {
  isEnabled: _propTypes.default.bool.isRequired,
  onEnabledChange: _propTypes.default.func.isRequired,
  partitioningFieldNames: _propTypes.default.array.isRequired,
  filterListIds: _propTypes.default.array.isRequired,
  scope: _propTypes.default.object,
  updateScope: _propTypes.default.func.isRequired
};