"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LayerSelect = LayerSelect;
exports.OBSERVABILITY_LAYER_TYPE = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/layers/wizards/solution_layers/observability/layer_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let OBSERVABILITY_LAYER_TYPE = exports.OBSERVABILITY_LAYER_TYPE = /*#__PURE__*/function (OBSERVABILITY_LAYER_TYPE) {
  OBSERVABILITY_LAYER_TYPE["APM_RUM_PERFORMANCE"] = "APM_RUM_PERFORMANCE";
  OBSERVABILITY_LAYER_TYPE["APM_RUM_TRAFFIC"] = "APM_RUM_TRAFFIC";
  return OBSERVABILITY_LAYER_TYPE;
}({});
const OBSERVABILITY_LAYER_OPTIONS = [{
  value: OBSERVABILITY_LAYER_TYPE.APM_RUM_PERFORMANCE,
  text: _i18n.i18n.translate('xpack.maps.observability.apmRumPerformanceLabel', {
    defaultMessage: 'APM RUM Performance'
  })
}, {
  value: OBSERVABILITY_LAYER_TYPE.APM_RUM_TRAFFIC,
  text: _i18n.i18n.translate('xpack.maps.observability.apmRumTrafficLabel', {
    defaultMessage: 'APM RUM Traffic'
  })
}];
function LayerSelect(props) {
  function onChange(event) {
    props.onChange(event.target.value);
  }
  const options = props.value ? OBSERVABILITY_LAYER_OPTIONS : [{
    value: '',
    text: ''
  }, ...OBSERVABILITY_LAYER_OPTIONS];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.maps.observability.layerLabel', {
      defaultMessage: 'Layer'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: options,
    value: props.value ? props.value : '',
    onChange: onChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }));
}