"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnnotationsPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eventAnnotationComponents = require("@kbn/event-annotation-components");
var _public = require("@kbn/kibana-react-plugin/public");
var _moment = _interopRequireDefault(require("moment"));
var _public2 = require("@kbn/data-plugin/public");
var _constants = require("../../../../../common/constants");
var _utils = require("../../../../utils");
var _ = require("..");
var _visualization_helpers = require("../../visualization_helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/xy/xy_config_panel/annotations_config_panel/annotations_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AnnotationsPanel = props => {
  var _localLayer$annotatio;
  const {
    state,
    setState,
    layerId,
    accessor,
    frame
  } = props;

  // we don't listen to the state prop after the initial render, because we don't want to
  // slow the annotation settings UI updates down on a full Redux state update
  const [localState, setLocalState] = (0, _react.useState)(state);
  const index = localState.layers.findIndex(l => l.layerId === layerId);
  const localLayer = localState.layers.find(l => l.layerId === layerId);
  const currentAnnotation = (_localLayer$annotatio = localLayer.annotations) === null || _localLayer$annotatio === void 0 ? void 0 : _localLayer$annotatio.find(c => c.id === accessor);
  const setAnnotation = (0, _react.useCallback)(annotation => {
    if (annotation == null) {
      return;
    }
    const newConfigs = [...(localLayer.annotations || [])];
    const existingIndex = newConfigs.findIndex(c => c.id === accessor);
    if (existingIndex !== -1) {
      newConfigs[existingIndex] = annotation;
    } else {
      throw new Error('should never happen because annotation is created before config panel is opened');
    }
    const newState = (0, _.updateLayer)(localState, {
      ...localLayer,
      annotations: newConfigs
    }, index);
    setLocalState(newState); // keep track up updates for controls state
    setState(newState); // notify the rest of the world, but don't wait
  }, [localLayer, localState, index, setState, accessor]);
  const [currentDataView, setCurrentDataView] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    const updateDataView = async () => {
      let dataView;
      const availableIds = await props.dataViewsService.getIds();
      if (availableIds.includes(localLayer.indexPatternId)) {
        dataView = await props.dataViewsService.get(localLayer.indexPatternId);
      } else {
        dataView = await props.dataViewsService.create(frame.dataViews.indexPatterns[localLayer.indexPatternId].spec);
      }
      setCurrentDataView(dataView);
    };
    updateDataView();
  }, [frame.dataViews.indexPatterns, localLayer.indexPatternId, props.dataViewsService]);
  const queryInputServices = (0, _public.useKibana)().services;
  if (!currentAnnotation) {
    throw new Error('Annotation not found... this should never happen!');
  }
  return currentDataView ? /*#__PURE__*/_react.default.createElement(_eventAnnotationComponents.AnnotationEditorControls, {
    annotation: currentAnnotation,
    onAnnotationChange: newAnnotation => setAnnotation(newAnnotation),
    dataView: currentDataView,
    getDefaultRangeEnd: rangeStart => getEndTimestamp(props.datatableUtilities, rangeStart, frame, localState.layers.filter(_visualization_helpers.isDataLayer)),
    queryInputServices: queryInputServices,
    calendarClassName: _utils.DONT_CLOSE_DIMENSION_CONTAINER_ON_CLICK_CLASS,
    appName: _constants.LENS_APP_NAME,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 5
    }
  }) : null;
};
exports.AnnotationsPanel = AnnotationsPanel;
const getEndTimestamp = (datatableUtilities, startTime, {
  activeData,
  absDateRange
}, dataLayers) => {
  var _datatableUtilities$g;
  const startTimeNumber = (0, _moment.default)(startTime).valueOf();
  const dateRangeFraction = ((0, _moment.default)(absDateRange.toDate).valueOf() - (0, _moment.default)(absDateRange.fromDate).valueOf()) * 0.1;
  const fallbackValue = (0, _moment.default)(startTimeNumber + dateRangeFraction).toISOString();
  const dataLayersId = dataLayers.map(({
    layerId
  }) => layerId);
  if (!dataLayersId.length || !activeData || Object.entries(activeData).filter(([key]) => dataLayersId.includes(key)).every(([, {
    rows
  }]) => !rows || !rows.length)) {
    return fallbackValue;
  }
  const xColumn = activeData === null || activeData === void 0 ? void 0 : activeData[dataLayersId[0]].columns.find(column => column.id === dataLayers[0].xAccessor);
  if (!xColumn) {
    return fallbackValue;
  }
  const dateInterval = (_datatableUtilities$g = datatableUtilities.getDateHistogramMeta(xColumn)) === null || _datatableUtilities$g === void 0 ? void 0 : _datatableUtilities$g.interval;
  if (!dateInterval) return fallbackValue;
  const intervalDuration = _public2.search.aggs.parseInterval(dateInterval);
  if (!intervalDuration) return fallbackValue;
  return (0, _moment.default)(startTimeNumber + 3 * intervalDuration.as('milliseconds')).toISOString();
};