"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LegendSettingsPopover = LegendSettingsPopover;
exports.MaxLinesInput = void 0;
exports.shouldDisplayTable = shouldDisplayTable;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _charts = require("@elastic/charts");
var _visualizationUtils = require("@kbn/visualization-utils");
var _toolbar_divider = require("../toolbar_divider");
var _toolbar_popover = require("../toolbar_popover");
var _legend_location_settings = require("./location/legend_location_settings");
var _columns_number_setting = require("./layout/columns_number_setting");
var _legend_size_settings = require("./size/legend_size_settings");
var _utils = require("../../utils");
var _toolbar_title_settings = require("../axis/title/toolbar_title_settings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/shared_components/legend/legend_settings_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DEFAULT_TRUNCATE_LINES = 1;
const MAX_TRUNCATE_LINES = 5;
const MIN_TRUNCATE_LINES = 1;
const MaxLinesInput = ({
  value,
  setValue,
  disabled
}) => {
  const {
    inputValue,
    handleInputChange
  } = (0, _visualizationUtils.useDebouncedValue)({
    value,
    onChange: setValue
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    disabled: disabled,
    fullWidth: true,
    prepend: _i18n.i18n.translate('xpack.lens.shared.maxLinesLabel', {
      defaultMessage: 'Line limit'
    }),
    "aria-label": _i18n.i18n.translate('xpack.lens.shared.maxLinesLabel', {
      defaultMessage: 'Line limit'
    }),
    "data-test-subj": "lens-legend-max-lines-input",
    value: inputValue,
    min: MIN_TRUNCATE_LINES,
    max: MAX_TRUNCATE_LINES,
    step: 1,
    compressed: true,
    onChange: e => {
      const val = Number(e.target.value);
      // we want to automatically change the values to the limits
      // if the user enters a value that is outside the limits
      handleInputChange(Math.min(MAX_TRUNCATE_LINES, Math.max(val, MIN_TRUNCATE_LINES)));
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 5
    }
  });
};
exports.MaxLinesInput = MaxLinesInput;
const noop = () => {};
const PANEL_STYLE = {
  width: '500px'
};
const legendTitleStrings = {
  header: _i18n.i18n.translate('xpack.lens.label.shared.legendHeader', {
    defaultMessage: 'Series header'
  }),
  label: _i18n.i18n.translate('xpack.lens.shared.Lagend ', {
    defaultMessage: 'Series header'
  }),
  placeholder: _i18n.i18n.translate('xpack.lens.shared.overwriteLegendTitle', {
    defaultMessage: 'Overwrite series header'
  }),
  getDataTestSubj: () => `lnsLegendTableSeriesHeader`
};
function shouldDisplayTable(legendValues) {
  return legendValues.some(v => v !== _charts.LegendValue.CurrentAndLastValue);
}
function LegendSettingsPopover({
  allowedLegendStats = [],
  legendOptions,
  mode,
  legendTitle,
  isTitleVisible,
  onLegendTitleChange,
  onDisplayChange,
  position,
  location,
  onLocationChange = noop,
  verticalAlignment,
  horizontalAlignment,
  floatingColumns,
  onAlignmentChange = noop,
  onFloatingColumnsChange = noop,
  onPositionChange,
  renderNestedLegendSwitch,
  nestedLegend,
  onNestedLegendChange = noop,
  legendStats = [],
  onLegendStatsChange = noop,
  groupPosition = 'none',
  maxLines,
  onMaxLinesChange = noop,
  shouldTruncate,
  onTruncateLegendChange = noop,
  legendSize,
  onLegendSizeChange,
  showAutoLegendSizeOption,
  titlePlaceholder
}) {
  const isLegendNotHidden = mode !== 'hide';
  const showsStatisticsSetting = isLegendNotHidden && allowedLegendStats.length > 1;
  const showsShowValueSetting = isLegendNotHidden && allowedLegendStats.length === 1 && (allowedLegendStats[0].value === _charts.LegendValue.CurrentAndLastValue || allowedLegendStats[0].value === _charts.LegendValue.Value);
  const showsLegendTitleSetting = shouldDisplayTable(legendStats) && !!onLegendTitleChange;
  return /*#__PURE__*/_react.default.createElement(_toolbar_popover.ToolbarPopover, {
    title: _i18n.i18n.translate('xpack.lens.shared.legendLabel', {
      defaultMessage: 'Legend'
    }),
    type: "legend",
    groupPosition: groupPosition,
    buttonDataTestSubj: "lnsLegendButton",
    panelStyle: PANEL_STYLE,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.lens.shared.legendVisibilityLabel', {
      defaultMessage: 'Visibility'
    }),
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    legend: _i18n.i18n.translate('xpack.lens.shared.legendVisibilityLabel', {
      defaultMessage: 'Visibility'
    }),
    "data-test-subj": "lens-legend-display-btn",
    buttonSize: "compressed",
    options: legendOptions,
    idSelected: legendOptions.find(({
      value
    }) => value === mode).id,
    onChange: onDisplayChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 9
    }
  })), isLegendNotHidden && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_legend_location_settings.LegendLocationSettings, {
    location: location,
    onLocationChange: onLocationChange,
    verticalAlignment: verticalAlignment,
    horizontalAlignment: horizontalAlignment,
    onAlignmentChange: onAlignmentChange,
    position: position,
    onPositionChange: onPositionChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 11
    }
  }), location !== 'inside' && /*#__PURE__*/_react.default.createElement(_legend_size_settings.LegendSizeSettings, {
    legendSize: legendSize,
    onLegendSizeChange: onLegendSizeChange,
    isVerticalLegend: !position || position === _charts.Position.Left || position === _charts.Position.Right,
    showAutoOption: showAutoLegendSizeOption,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 298,
      columnNumber: 13
    }
  }), location && /*#__PURE__*/_react.default.createElement(_columns_number_setting.ColumnsNumberSetting, {
    floatingColumns: floatingColumns,
    onFloatingColumnsChange: onFloatingColumnsChange,
    isHidden: location === 'outside' || shouldDisplayTable(legendStats),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 308,
      columnNumber: 13
    }
  })), showsStatisticsSetting && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_toolbar_divider.ToolbarDivider, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 319,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.lens.shared.legendStatistics', {
      defaultMessage: 'Statistics'
    }),
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 320,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "aria-label": _i18n.i18n.translate('xpack.lens.shared.legendStatistics', {
      defaultMessage: 'Statistics'
    }),
    "data-test-subj": "lnsLegendStatisticsSelect",
    placeholder: _i18n.i18n.translate('xpack.lens.shared.legendStatisticsPlaceholder', {
      defaultMessage: 'Select one or more statistics to show'
    }),
    options: allowedLegendStats,
    selectedOptions: legendStats.map(value => allowedLegendStats.find(option => option.value === value)).filter(_utils.nonNullable),
    onChange: options => {
      const newLegendStats = options.map(({
        value
      }) => value).filter(_utils.nonNullable);
      const hasConvertedToTable = !shouldDisplayTable(legendStats) && shouldDisplayTable(newLegendStats);
      onLegendStatsChange(newLegendStats, hasConvertedToTable);
    },
    isClearable: true,
    compressed: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 327,
      columnNumber: 13
    }
  }))), showsLegendTitleSetting && /*#__PURE__*/_react.default.createElement(_toolbar_title_settings.ToolbarTitleSettings, {
    settingId: "legend",
    title: legendTitle,
    isTitleVisible: !!isTitleVisible,
    updateTitleState: onLegendTitleChange,
    strings: legendTitleStrings,
    placeholder: titlePlaceholder,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 353,
      columnNumber: 9
    }
  }), showsShowValueSetting && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.lens.shared.valueInLegendLabel', {
      defaultMessage: 'Show value'
    }),
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 363,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    label: _i18n.i18n.translate('xpack.lens.shared.valueInLegendLabel', {
      defaultMessage: 'Show value'
    }),
    "data-test-subj": "lens-legend-show-value",
    showLabel: false,
    checked: !!(legendStats !== null && legendStats !== void 0 && legendStats.length),
    onChange: ev => {
      onLegendStatsChange(ev.target.checked ? [allowedLegendStats[0].value] : []);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 370,
      columnNumber: 11
    }
  })), isLegendNotHidden && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.lens.shared.labelTruncation', {
      defaultMessage: 'Label truncation'
    }),
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 386,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 393,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 394,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    label: _i18n.i18n.translate('xpack.lens.shared.labelTruncation', {
      defaultMessage: 'Label truncation'
    }),
    "data-test-subj": "lens-legend-truncate-switch",
    showLabel: false,
    checked: shouldTruncate !== null && shouldTruncate !== void 0 ? shouldTruncate : true,
    onChange: onTruncateLegendChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 395,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 406,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(MaxLinesInput, {
    disabled: !shouldTruncate,
    value: maxLines !== null && maxLines !== void 0 ? maxLines : DEFAULT_TRUNCATE_LINES,
    setValue: onMaxLinesChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 407,
      columnNumber: 15
    }
  })))), isLegendNotHidden && renderNestedLegendSwitch && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.lens.shared.nestedLegendLabel', {
      defaultMessage: 'Nested'
    }),
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 418,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    label: _i18n.i18n.translate('xpack.lens.pieChart.nestedLegendLabel', {
      defaultMessage: 'Nested'
    }),
    "data-test-subj": "lens-legend-nested-switch",
    showLabel: false,
    checked: Boolean(nestedLegend),
    onChange: onNestedLegendChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 425,
      columnNumber: 11
    }
  })));
}