"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldSelect = FieldSelect;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _visualizationUiComponents = require("@kbn/visualization-ui-components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/datasources/form_based/esql_layer/components/field_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function FieldSelect({
  selectedField,
  onChoose,
  existingFields,
  ['data-test-subj']: dataTestSub
}) {
  var _selectedField$meta;
  const memoizedFieldOptions = (0, _react.useMemo)(() => {
    const availableFields = existingFields.map(field => {
      var _field$meta;
      const dataType = field === null || field === void 0 ? void 0 : (_field$meta = field.meta) === null || _field$meta === void 0 ? void 0 : _field$meta.type;
      return {
        compatible: field.compatible ? 1 : 0,
        exists: true,
        label: field.name,
        value: {
          type: 'field',
          field: field.name,
          dataType
        }
      };
    }).sort((a, b) => b.compatible - a.compatible);
    return [{
      label: _i18n.i18n.translate('xpack.lens.indexPattern.availableFieldsLabel', {
        defaultMessage: 'Available fields'
      }),
      options: availableFields
    }];
  }, [existingFields]);
  return /*#__PURE__*/_react.default.createElement(_visualizationUiComponents.FieldPicker, {
    activeField: selectedField ? {
      label: selectedField.fieldName,
      value: {
        type: 'field',
        field: selectedField.fieldName,
        dataType: selectedField === null || selectedField === void 0 ? void 0 : (_selectedField$meta = selectedField.meta) === null || _selectedField$meta === void 0 ? void 0 : _selectedField$meta.type
      }
    } : undefined,
    options: memoizedFieldOptions,
    onChoose: choice => {
      if (choice && choice.field !== (selectedField === null || selectedField === void 0 ? void 0 : selectedField.fieldName)) {
        onChoose(choice);
      }
    },
    fieldIsInvalid: false,
    "data-test-subj": dataTestSub !== null && dataTestSub !== void 0 ? dataTestSub : 'text-based-dimension-field',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  });
}