"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Json = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _shared_imports = require("../../../../../../shared_imports");
var _shared = require("./shared");
var _field_name_field = require("./common_fields/field_name_field");
var _target_field = require("./common_fields/target_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/processor_form/processors/json.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ADD_TO_ROOT_FIELD_PATH = 'fields.add_to_root';
const fieldsConfig = {
  /* Optional fields config */
  add_to_root: {
    type: _shared_imports.FIELD_TYPES.TOGGLE,
    defaultValue: false,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.jsonForm.addToRootFieldLabel', {
      defaultMessage: 'Add to root'
    }),
    deserializer: _shared.to.booleanOrUndef,
    serializer: _shared.from.undefinedIfValue(false),
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.jsonForm.addToRootFieldHelpText', {
      defaultMessage: 'Add the JSON object to the top level of the document. Cannot be combined with a target field.'
    })
  }
};
const Json = () => {
  const form = (0, _shared_imports.useFormContext)();
  const [isAddToPathDisabled, setIsAddToPathDisabled] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    const subscription = form.subscribe(({
      data: {
        internal
      }
    }) => {
      const hasTargetField = !!(0, _lodash.get)(internal, _target_field.TARGET_FIELD_PATH);
      if (hasTargetField && !isAddToPathDisabled) {
        setIsAddToPathDisabled(true);
        form.getFields()[ADD_TO_ROOT_FIELD_PATH].setValue(false);
      } else if (!hasTargetField && isAddToPathDisabled) {
        setIsAddToPathDisabled(false);
      }
    });
    return subscription.unsubscribe;
  }, [form, isAddToPathDisabled]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_field_name_field.FieldNameField, {
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.jsonForm.fieldNameHelpText', {
      defaultMessage: 'Field to parse.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_target_field.TargetField, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.add_to_root,
    component: _shared_imports.ToggleField,
    componentProps: {
      euiFieldProps: {
        disabled: isAddToPathDisabled
      }
    },
    path: ADD_TO_ROOT_FIELD_PATH,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }));
};
exports.Json = Json;