"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Osquery = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _plugin_config_context = require("../../../../containers/plugin_config_context");
var _use_kibana = require("../../../../hooks/use_kibana");
var _use_metadata_state = require("../../hooks/use_metadata_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/tabs/osquery/osquery.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Osquery = () => {
  var _metadata$info, _metadata$info$agent, _agentId$current;
  const {
    metadata,
    loading
  } = (0, _use_metadata_state.useMetadataStateContext)();
  const agentId = (0, _react.useRef)(undefined);

  // When a host has multiple agents reporting metrics, it's possible that one of them may not report an agent id.
  // This ensures that once an agent id is found, it won't be replaced.
  if (metadata !== null && metadata !== void 0 && (_metadata$info = metadata.info) !== null && _metadata$info !== void 0 && (_metadata$info$agent = _metadata$info.agent) !== null && _metadata$info$agent !== void 0 && _metadata$info$agent.id && !agentId.current) {
    agentId.current = metadata.info.agent.id;
  }
  const {
    featureFlags
  } = (0, _plugin_config_context.usePluginConfig)();
  if (!featureFlags.osqueryEnabled) {
    return null;
  }
  const isLoading = loading && !metadata;
  return isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 10,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 5
    }
  }) :
  /*#__PURE__*/
  // Osquery must receive an agent id for it to function in infra. There may be incomplete metric documents without this information, causing the metadata endpoint to return incomplete data.
  // To prevent incorrect Osquery form rendering, we're passing an invalid agent id. This ensures the user sees the 'not available' message instead of the form.
  _react.default.createElement(MemoOsQueryAction, {
    agentId: (_agentId$current = agentId.current) !== null && _agentId$current !== void 0 ? _agentId$current : '_na',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  });
};
exports.Osquery = Osquery;
const MemoOsQueryAction = /*#__PURE__*/_react.default.memo(({
  agentId
}) => {
  const {
    services: {
      osquery
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();

  // @ts-expect-error
  const OsqueryAction = osquery === null || osquery === void 0 ? void 0 : osquery.OsqueryAction;
  return !OsqueryAction ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 10,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(OsqueryAction, {
    agentId: agentId,
    hideAgentsField: true,
    formType: "simple",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  });
});