"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricRowWithCount = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _unified_search_bar = require("../../../../components/shared/unified_search_bar");
var _metrics = require("../../../../../common/alerting/metrics");
var _metric_row_controls = require("./metric_row_controls");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/alerting/metric_threshold/components/custom_equation/metric_row_with_count.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MetricRowWithCount = ({
  name,
  agg,
  filter,
  onDelete,
  disableDelete,
  onChange,
  aggregationTypes
}) => {
  const aggOptions = (0, _react.useMemo)(() => Object.values(aggregationTypes).filter(aggType => aggType.value !== _metrics.Aggregators.CUSTOM).map(aggType => ({
    text: aggType.text,
    value: aggType.value
  })), [aggregationTypes]);
  const handleDelete = (0, _react.useCallback)(() => {
    onDelete(name);
  }, [name, onDelete]);
  const handleAggChange = (0, _react.useCallback)(el => {
    onChange({
      name,
      filter,
      aggType: el.target.value
    });
  }, [name, filter, onChange]);
  const handleFilterChange = (0, _react.useCallback)(payload => {
    var _payload$query;
    const kuery = (_payload$query = payload.query) === null || _payload$query === void 0 ? void 0 : _payload$query.query;
    onChange({
      name,
      filter: kuery,
      aggType: agg
    });
  }, [name, agg, onChange]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      maxWidth: 145
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.customEquationEditor.aggregationLabel', {
      defaultMessage: 'Aggregation {name}',
      values: {
        name
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "infraMetricRowWithCountSelect",
    options: aggOptions,
    value: agg,
    onChange: handleAggChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.customEquationEditor.filterLabel', {
      defaultMessage: 'KQL Filter {name}',
      values: {
        name
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_unified_search_bar.UnifiedSearchBar, {
    onQuerySubmit: handleFilterChange,
    showPlaceholder: false,
    useDefaultBehaviors: false,
    query: {
      query: filter || '',
      language: 'kuery'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_metric_row_controls.MetricRowControls, {
    onDelete: handleDelete,
    disableDelete: disableDelete,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }));
};
exports.MetricRowWithCount = MetricRowWithCount;