"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getProvider = exports.getModelId = exports.getElasticModelProvider = void 0;
var _inferenceCommon = require("@kbn/inference-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns the modelId used by the underlying endpoint of the given inference connector
 */
const getModelId = connector => {
  var _connector$config$pro, _connector$config, _connector$config$pro2;
  if (connector.type !== _inferenceCommon.InferenceConnectorType.Inference) {
    throw new Error(`trying to get modelId for a non-inference connector (${connector.type})`);
  }
  return (_connector$config$pro = (_connector$config = connector.config) === null || _connector$config === void 0 ? void 0 : (_connector$config$pro2 = _connector$config.providerConfig) === null || _connector$config$pro2 === void 0 ? void 0 : _connector$config$pro2.model_id) !== null && _connector$config$pro !== void 0 ? _connector$config$pro : undefined;
};

/**
 * Returns the provider used by the underlying endpoint of the given inference connector
 */
exports.getModelId = getModelId;
const getProvider = connector => {
  var _connector$config$pro3, _connector$config2;
  if (connector.type !== _inferenceCommon.InferenceConnectorType.Inference) {
    throw new Error(`trying to get provider for a non-inference connector (${connector.type})`);
  }
  return (_connector$config$pro3 = (_connector$config2 = connector.config) === null || _connector$config2 === void 0 ? void 0 : _connector$config2.provider) !== null && _connector$config$pro3 !== void 0 ? _connector$config$pro3 : undefined;
};

/**
 * Returns the provider used by the underlying endpoint of the given inference connector
 */
exports.getProvider = getProvider;
const getElasticModelProvider = connector => {
  const provider = getProvider(connector);
  if (!provider || provider !== _inferenceCommon.InferenceEndpointProvider.Elastic) {
    throw new Error(`trying to retrieve model provider for a non-elastic inference endpoint (${provider})`);
  }
  const modelId = getModelId(connector);
  if (modelId === _inferenceCommon.elasticModelIds.RainbowSprinkles) {
    return _inferenceCommon.InferenceEndpointProvider.AmazonBedrock;
  }
  return undefined;
};
exports.getElasticModelProvider = getElasticModelProvider;