"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TypeParameter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _documentation = require("../../../../../services/documentation");
var _lib = require("../../../lib");
var _shared_imports = require("../../../shared_imports");
var _constants = require("../../../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/document_fields/field_parameters/type_parameter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TypeParameter = ({
  isMultiField,
  isRootLevelField,
  showDocLink = false,
  isSemanticTextEnabled = true,
  fieldTypeInputRef
}) => {
  const fieldTypeOptions = (0, _react.useMemo)(() => {
    let options = isMultiField ? (0, _lib.filterTypesForMultiField)(_constants.FIELD_TYPES_OPTIONS) : isRootLevelField ? _constants.FIELD_TYPES_OPTIONS : (0, _lib.filterTypesForNonRootFields)(_constants.FIELD_TYPES_OPTIONS);
    if (!isSemanticTextEnabled) {
      options = options.filter(option => option.value !== 'semantic_text');
    }
    return options;
  }, [isMultiField, isRootLevelField, isSemanticTextEnabled]);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "type",
    config: (0, _lib.getFieldConfig)('type'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 5
    }
  }, typeField => {
    const error = typeField.getErrorsMessages();
    const isInvalid = error ? Boolean(error.length) : false;
    let docLink = null;
    if (showDocLink && typeField.value.length > 0) {
      const selectedType = typeField.value[0].value;
      docLink = _documentation.documentationService.getTypeDocLink(selectedType);
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: typeField.label,
      error: error,
      isInvalid: isInvalid,
      helpText: docLink ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 70,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLink,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 71,
          columnNumber: 19
        }
      }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.typeField.documentationLinkLabel', {
        defaultMessage: '{typeName} documentation',
        values: {
          typeName: typeField.value && typeField.value[0] ? typeField.value[0].label : ''
        }
      }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 85,
          columnNumber: 17
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      isInvalid: isInvalid,
      placeholder: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.typeField.placeholderLabel', {
        defaultMessage: 'Select a type'
      }),
      singleSelection: {
        asPlainText: true
      },
      options: fieldTypeOptions,
      selectedOptions: typeField.value,
      onChange: typeField.setValue,
      isClearable: false,
      "data-test-subj": "fieldType",
      inputRef: input => {
        if (fieldTypeInputRef) fieldTypeInputRef.current = input;
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 13
      }
    }));
  });
};
exports.TypeParameter = TypeParameter;