"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Timeline = void 0;
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../shared_imports");
var _lib = require("../../lib");
var _ = require("..");
var _components = require("./components");
var _timeline = require("./timeline.styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/index_lifecycle_management/public/application/sections/edit_policy/components/timeline/timeline.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const exists = v => v != null;
const toPercent = (n, total) => n / total * 100;
const msTimeToOverallPercent = (ms, totalMs) => {
  if (!isFinite(ms)) {
    return 100;
  }
  if (totalMs === 0) {
    return 100;
  }
  return toPercent(ms, totalMs);
};

/**
 * Each phase, if active, should have a minimum width it occupies. The higher this
 * base amount, the smaller the variance in phase size in the timeline. This functions
 * as a min-width constraint.
 */
const SCORE_BUFFER_AMOUNT = 50;
const i18nTexts = {
  title: _i18n.i18n.translate('xpack.indexLifecycleMgmt.timeline.title', {
    defaultMessage: 'Policy summary'
  }),
  description: _i18n.i18n.translate('xpack.indexLifecycleMgmt.timeline.description', {
    defaultMessage: 'This policy moves data through the following phases.'
  }),
  hotPhase: _i18n.i18n.translate('xpack.indexLifecycleMgmt.timeline.hotPhaseSectionTitle', {
    defaultMessage: 'Hot phase'
  }),
  warmPhase: _i18n.i18n.translate('xpack.indexLifecycleMgmt.timeline.warmPhaseSectionTitle', {
    defaultMessage: 'Warm phase'
  }),
  coldPhase: _i18n.i18n.translate('xpack.indexLifecycleMgmt.timeline.coldPhaseSectionTitle', {
    defaultMessage: 'Cold phase'
  }),
  frozenPhase: _i18n.i18n.translate('xpack.indexLifecycleMgmt.timeline.frozenPhaseSectionTitle', {
    defaultMessage: 'Frozen phase'
  }),
  deleteIcon: {
    toolTipContent: _i18n.i18n.translate('xpack.indexLifecycleMgmt.timeline.deleteIconToolTipContent', {
      defaultMessage: 'Policy deletes the index after lifecycle phases complete.'
    })
  },
  foreverIcon: {
    ariaLabel: _i18n.i18n.translate('xpack.indexLifecycleMgmt.timeline.foreverIconToolTipContent', {
      defaultMessage: 'Forever'
    })
  }
};
const calculateWidths = inputs => {
  const hotScore = msTimeToOverallPercent(inputs.phases.hot, inputs.total) + SCORE_BUFFER_AMOUNT;
  const warmScore = inputs.phases.warm != null ? msTimeToOverallPercent(inputs.phases.warm, inputs.total) + SCORE_BUFFER_AMOUNT : 0;
  const coldScore = inputs.phases.cold != null ? msTimeToOverallPercent(inputs.phases.cold, inputs.total) + SCORE_BUFFER_AMOUNT : 0;
  const frozenScore = inputs.phases.frozen != null ? msTimeToOverallPercent(inputs.phases.frozen, inputs.total) + SCORE_BUFFER_AMOUNT : 0;
  const totalScore = hotScore + warmScore + coldScore + frozenScore;
  return {
    hot: `${toPercent(hotScore, totalScore)}%`,
    warm: `${toPercent(warmScore, totalScore)}%`,
    cold: `${toPercent(coldScore, totalScore)}%`,
    frozen: `${toPercent(frozenScore, totalScore)}%`
  };
};
/**
 * Display a timeline given ILM policy phase information. This component is re-usable and memo-ized
 * and should not rely directly on any application-specific context.
 */
const Timeline = exports.Timeline = /*#__PURE__*/(0, _react.memo)(({
  hasDeletePhase,
  isUsingRollover,
  showTitle = true,
  ...phasesMinAge
}) => {
  const absoluteTimings = {
    hot: {
      min_age: phasesMinAge.hotPhaseMinAge
    },
    warm: phasesMinAge.warmPhaseMinAge ? {
      min_age: phasesMinAge.warmPhaseMinAge
    } : undefined,
    cold: phasesMinAge.coldPhaseMinAge ? {
      min_age: phasesMinAge.coldPhaseMinAge
    } : undefined,
    frozen: phasesMinAge.frozenPhaseMinAge ? {
      min_age: phasesMinAge.frozenPhaseMinAge
    } : undefined,
    delete: phasesMinAge.deletePhaseMinAge ? {
      min_age: phasesMinAge.deletePhaseMinAge
    } : undefined
  };
  const styles = (0, _timeline.useStyles)();
  const phaseAgeInMilliseconds = (0, _lib.calculateRelativeFromAbsoluteMilliseconds)(absoluteTimings);
  const widths = calculateWidths(phaseAgeInMilliseconds);
  const getDurationInPhaseContent = phase => phaseAgeInMilliseconds.phases[phase] === Infinity ? /*#__PURE__*/_react.default.createElement(_.InfinityIcon, {
    color: "subdued",
    "aria-label": i18nTexts.foreverIcon.ariaLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 9
    }
  }) : null;
  const {
    docLinks
  } = (0, _shared_imports.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 7
    }
  }, showTitle && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 15
    }
  }, i18nTexts.title)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 13
    }
  }, i18nTexts.description, "\xA0", /*#__PURE__*/_react.default.createElement(_.LearnMoreLink, {
    docPath: docLinks.links.elasticsearch.ilmPhaseTransitions,
    text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.indexLifecycleMgmt.editPolicy.learnAboutTimingText",
      defaultMessage: "Learn about timing",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 161,
        columnNumber: 19
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: styles.container,
    ref: el => {
      if (el) {
        var _widths$warm, _widths$cold, _widths$frozen;
        el.style.setProperty('--ilm-timeline-hot-phase-width', widths.hot);
        el.style.setProperty('--ilm-timeline-warm-phase-width', (_widths$warm = widths.warm) !== null && _widths$warm !== void 0 ? _widths$warm : null);
        el.style.setProperty('--ilm-timeline-cold-phase-width', (_widths$cold = widths.cold) !== null && _widths$cold !== void 0 ? _widths$cold : null);
        el.style.setProperty('--ilm-timeline-frozen-phase-width', (_widths$frozen = widths.frozen) !== null && _widths$frozen !== void 0 ? _widths$frozen : null);
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "flexStart",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: styles.phasesContainer,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "ilmTimelinePhase-hot",
    css: [styles.phase, styles.hotPhase],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: styles.hotColorBar,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react.default.createElement(_components.TimelinePhaseText, {
    phaseName: i18nTexts.hotPhase,
    durationInPhase: getDurationInPhaseContent('hot'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 21
    }
  })), exists(phaseAgeInMilliseconds.phases.warm) && /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "ilmTimelinePhase-warm",
    css: [styles.phase, styles.warmPhase],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: styles.warmColorBar,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 23
    }
  }), /*#__PURE__*/_react.default.createElement(_components.TimelinePhaseText, {
    phaseName: i18nTexts.warmPhase,
    durationInPhase: getDurationInPhaseContent('warm'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 23
    }
  })), exists(phaseAgeInMilliseconds.phases.cold) && /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "ilmTimelinePhase-cold",
    css: [styles.phase, styles.coldPhase],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: styles.coldColorBar,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 23
    }
  }), /*#__PURE__*/_react.default.createElement(_components.TimelinePhaseText, {
    phaseName: i18nTexts.coldPhase,
    durationInPhase: getDurationInPhaseContent('cold'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 23
    }
  })), exists(phaseAgeInMilliseconds.phases.frozen) && /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "ilmTimelinePhase-frozen",
    css: [styles.phase, styles.frozenPhase],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: styles.frozenColorBar,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 23
    }
  }), /*#__PURE__*/_react.default.createElement(_components.TimelinePhaseText, {
    phaseName: i18nTexts.frozenPhase,
    durationInPhase: getDurationInPhaseContent('frozen'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 23
    }
  })))), hasDeletePhase && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "ilmTimelinePhase-delete",
    css: styles.deleteIconContainer,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    type: "trash",
    content: i18nTexts.deleteIcon.toolTipContent,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 21
    }
  })))))));
});