"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDeleteProxy = useDeleteProxy;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../hooks");
var _use_confirm_modal = require("./use_confirm_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/settings/hooks/use_delete_proxy.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConfirmTitle = () => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.settings.deleteFleetProxy.confirmModalTitle",
  defaultMessage: "Delete and deploy changes?",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 18,
    columnNumber: 3
  }
});
const ConfirmDescription = ({}) => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.settings.deleteFleetProxy.confirmModalText",
  defaultMessage: "This action will change agent policies currently using that proxy. Are you sure you wish to continue?",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 25,
    columnNumber: 3
  }
});
function useDeleteProxy(onSuccess) {
  const {
    confirm
  } = (0, _use_confirm_modal.useConfirmModal)();
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const deleteFleetProxy = (0, _react.useCallback)(async fleetProxy => {
    try {
      const isConfirmed = await confirm(/*#__PURE__*/_react.default.createElement(ConfirmTitle, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 37,
          columnNumber: 43
        }
      }), /*#__PURE__*/_react.default.createElement(ConfirmDescription, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 37,
          columnNumber: 61
        }
      }), {
        buttonColor: 'danger',
        confirmButtonText: _i18n.i18n.translate('xpack.fleet.settings.deleteFleetProxy.confirmButtonLabel', {
          defaultMessage: 'Delete and deploy changes'
        })
      });
      if (!isConfirmed) {
        return;
      }
      const res = await (0, _hooks.sendDeleteFleetProxy)(fleetProxy.id);
      if (res.error) {
        throw res.error;
      }
      onSuccess();
    } catch (err) {
      notifications.toasts.addError(err, {
        title: _i18n.i18n.translate('xpack.fleet.settings.deleteFleetProxy.errorToastTitle', {
          defaultMessage: 'Error deleting proxy'
        })
      });
    }
  }, [confirm, notifications.toasts, onSuccess]);
  return {
    deleteFleetProxy
  };
}