"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OutputFormKafkaBroker = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/settings/components/edit_output_flyout/output_form_kafka_broker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OutputFormKafkaBroker = props => {
  const {
    inputs
  } = props;
  const kafkaBrokerTimeoutOptions = (0, _react.useMemo)(() => Array.from({
    length: 6
  }, (_, i) => (i + 1) * 10).map(timeout => ({
    text: timeout,
    label: `${timeout} seconds`
  })), []);
  const getAckReliabilityLabel = value => {
    switch (value) {
      case _constants.kafkaAcknowledgeReliabilityLevel.DoNotWait:
        return 'No response';
      case _constants.kafkaAcknowledgeReliabilityLevel.Replica:
        return 'Wait for all replicas to commit';
      default:
      case _constants.kafkaAcknowledgeReliabilityLevel.Commit:
        return 'Wait for local commit';
    }
  };
  const kafkaBrokerAckReliabilityOptions = (0, _react.useMemo)(() => Object.keys(_constants.kafkaAcknowledgeReliabilityLevel).map(key => {
    return {
      text: _constants.kafkaAcknowledgeReliabilityLevel[key],
      label: getAckReliabilityLabel(_constants.kafkaAcknowledgeReliabilityLevel[key])
    };
  }), []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    borderRadius: "m",
    hasShadow: false,
    paddingSize: 'm',
    color: 'subdued',
    "data-test-subj": "settingsOutputsFlyout.kafkaBrokerSettingsPanel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    id: "FleetEditOutputFlyoutKafkaBrokerSettings",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.editOutputFlyout.kafkaBrokerSettingsTitle",
    defaultMessage: "Broker settings",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.kafkaBrokerTimeoutInputLabel",
      defaultMessage: "Broker timeout",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 11
      }
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.kafkaBrokerTimeoutInputHelpText",
      defaultMessage: "Define how long a Kafka server waits for data in the same cluster.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, (0, _extends2.default)({
    fullWidth: true,
    "data-test-subj": "settingsOutputsFlyout.kafkaBrokerTimeoutInput"
  }, inputs.kafkaBrokerTimeoutInput.props, {
    options: kafkaBrokerTimeoutOptions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 9
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.kafkaBrokerReachabilityTimeoutInputLabel",
      defaultMessage: "Broker reachability timeout",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 11
      }
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.kafkaBrokerReachabilityTimeoutInputHelpText",
      defaultMessage: "Define how long an Agent would wait for a response from Kafka broker.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, (0, _extends2.default)({
    fullWidth: true,
    "data-test-subj": "settingsOutputsFlyout.kafkaBrokerReachabilityTimeoutInput"
  }, inputs.kafkaBrokerReachabilityTimeoutInput.props, {
    options: kafkaBrokerTimeoutOptions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 9
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.kafkaBrokerAckReliabilityInputLabel",
      defaultMessage: "ACK Reliability",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 11
      }
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.kafkaBrokerAckReliabilityInputHelpText",
      defaultMessage: "Reliability level required from the broker.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, (0, _extends2.default)({
    fullWidth: true,
    "data-test-subj": "settingsOutputsFlyout.kafkaBrokerAckReliabilityInputLabel"
  }, inputs.kafkaBrokerAckReliabilityInput.props, {
    options: kafkaBrokerAckReliabilityOptions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 9
    }
  }))));
};
exports.OutputFormKafkaBroker = OutputFormKafkaBroker;