"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFleetProxyForm = useFleetProxyForm;
exports.validateName = validateName;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _jsYaml = require("js-yaml");
var _hooks = require("../../../../hooks");
var _use_confirm_modal = require("../../hooks/use_confirm_modal");
var _constants = require("../../../../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/settings/components/edit_fleet_proxy_flyout/use_fleet_proxy_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConfirmTitle = () => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.settings.fleetProxyFlyout.confirmModalTitle",
  defaultMessage: "Save and deploy changes?",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 27,
    columnNumber: 3
  }
});
const ConfirmDescription = ({}) => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.settings.fleetProxyFlyout.confirmModalText",
  defaultMessage: "This action will update agent policies using this proxy. This action can not be undone. Are you sure you wish to continue?",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 34,
    columnNumber: 3
  }
});
function validateUrl(value) {
  if (!value || value === '') {
    return [_i18n.i18n.translate('xpack.fleet.settings.fleetProxyFlyoutUrlRequired', {
      defaultMessage: 'URL is required'
    })];
  }
  if (!value.match(_constants.PROXY_URL_REGEX)) {
    return [_i18n.i18n.translate('xpack.fleet.settings.fleetProxyFlyoutUrlError', {
      defaultMessage: 'Invalid URL'
    })];
  }
}
function validateProxyHeaders(value) {
  if (value && value !== '') {
    const res = (0, _jsYaml.load)(value);
    if (typeof res !== 'object' || Object.values(res).some(val => {
      const valType = typeof val;
      return valType !== 'string' && valType !== 'number' && valType !== 'boolean';
    })) {
      return [_i18n.i18n.translate('xpack.fleet.settings.fleetProxy.proxyHeadersErrorMessage', {
        defaultMessage: 'Proxy headers is not a valid key: value object.'
      })];
    }
  }
}
function validateName(value) {
  if (!value || value === '') {
    return [_i18n.i18n.translate('xpack.fleet.settings.fleetProxy.nameIsRequiredErrorMessage', {
      defaultMessage: 'Name is required'
    })];
  }
}
function useFleetProxyForm(fleetProxy, onSuccess) {
  var _ref, _fleetProxy$name, _fleetProxy$url, _fleetProxy$certifica, _fleetProxy$certifica2, _fleetProxy$certifica3;
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const authz = (0, _hooks.useAuthz)();
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const {
    confirm
  } = (0, _use_confirm_modal.useConfirmModal)();
  const isEditDisabled = (_ref = !authz.fleet.allSettings || (fleetProxy === null || fleetProxy === void 0 ? void 0 : fleetProxy.is_preconfigured)) !== null && _ref !== void 0 ? _ref : false;
  const nameInput = (0, _hooks.useInput)((_fleetProxy$name = fleetProxy === null || fleetProxy === void 0 ? void 0 : fleetProxy.name) !== null && _fleetProxy$name !== void 0 ? _fleetProxy$name : '', validateName, isEditDisabled);
  const urlInput = (0, _hooks.useInput)((_fleetProxy$url = fleetProxy === null || fleetProxy === void 0 ? void 0 : fleetProxy.url) !== null && _fleetProxy$url !== void 0 ? _fleetProxy$url : '', validateUrl, isEditDisabled);
  const proxyHeadersInput = (0, _hooks.useInput)(fleetProxy !== null && fleetProxy !== void 0 && fleetProxy.proxy_headers ? (0, _jsYaml.dump)(fleetProxy.proxy_headers) : '', validateProxyHeaders, isEditDisabled);
  const certificateAuthoritiesInput = (0, _hooks.useInput)((_fleetProxy$certifica = fleetProxy === null || fleetProxy === void 0 ? void 0 : fleetProxy.certificate_authorities) !== null && _fleetProxy$certifica !== void 0 ? _fleetProxy$certifica : '', () => undefined, isEditDisabled);
  const certificateInput = (0, _hooks.useInput)((_fleetProxy$certifica2 = fleetProxy === null || fleetProxy === void 0 ? void 0 : fleetProxy.certificate) !== null && _fleetProxy$certifica2 !== void 0 ? _fleetProxy$certifica2 : '', () => undefined, isEditDisabled);
  const certificateKeyInput = (0, _hooks.useInput)((_fleetProxy$certifica3 = fleetProxy === null || fleetProxy === void 0 ? void 0 : fleetProxy.certificate_key) !== null && _fleetProxy$certifica3 !== void 0 ? _fleetProxy$certifica3 : '', () => undefined, isEditDisabled);
  const inputs = (0, _react.useMemo)(() => ({
    nameInput,
    urlInput,
    proxyHeadersInput,
    certificateAuthoritiesInput,
    certificateInput,
    certificateKeyInput
  }), [nameInput, urlInput, proxyHeadersInput, certificateAuthoritiesInput, certificateInput, certificateKeyInput]);
  const validate = (0, _react.useCallback)(() => (0, _hooks.validateInputs)(inputs), [inputs]);
  const submit = (0, _react.useCallback)(async () => {
    try {
      if (!validate()) {
        return;
      }
      if (fleetProxy && !(await confirm(/*#__PURE__*/_react.default.createElement(ConfirmTitle, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 139,
          columnNumber: 41
        }
      }), /*#__PURE__*/_react.default.createElement(ConfirmDescription, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 139,
          columnNumber: 59
        }
      })))) {
        return;
      }
      setIsLoading(true);
      const data = {
        name: nameInput.value,
        url: urlInput.value,
        proxy_headers: proxyHeadersInput.value === '' ? undefined : (0, _jsYaml.load)(proxyHeadersInput.value),
        certificate_authorities: certificateAuthoritiesInput.value,
        certificate: certificateInput.value,
        certificate_key: certificateKeyInput.value
      };
      if (fleetProxy) {
        const res = await (0, _hooks.sendPutFleetProxy)(fleetProxy.id, data);
        if (res.error) {
          throw res.error;
        }
      } else {
        const res = await (0, _hooks.sendPostFleetProxy)(data);
        if (res.error) {
          throw res.error;
        }
      }
      notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.fleet.settings.fleetProxyFlyout.successToastTitle', {
        defaultMessage: 'Fleet proxy saved'
      }));
      setIsLoading(false);
      await onSuccess();
    } catch (error) {
      setIsLoading(false);
      notifications.toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.fleet.settings.fleetProxyFlyout.errorToastTitle', {
          defaultMessage: 'An error happened while saving Fleet Server host'
        })
      });
    }
  }, [fleetProxy, nameInput.value, urlInput.value, proxyHeadersInput.value, certificateAuthoritiesInput.value, certificateInput.value, certificateKeyInput.value, validate, notifications, confirm, onSuccess]);
  const hasChanged = Object.values(inputs).some(input => input.hasChanged);
  const isDisabled = isLoading || !hasChanged || nameInput.props.isInvalid || urlInput.props.isInvalid;
  return {
    isLoading,
    isDisabled,
    submit,
    inputs
  };
}