"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataStreamListPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../hooks");
var _components = require("../../../components");
var _data_stream_row_actions = require("./components/data_stream_row_actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/data_stream/list_page/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DataStreamListPage = () => {
  (0, _hooks.useBreadcrumbs)('data_streams');
  const {
    pagination,
    pageSizeOptions
  } = (0, _hooks.usePagination)();

  // Fetch data streams
  const {
    isLoading,
    data: dataStreamsData,
    resendRequest
  } = (0, _hooks.useGetDataStreams)();

  // Some policies retrieved, set up table props
  const columns = (0, _react.useMemo)(() => {
    const cols = [{
      field: 'dataset',
      sortable: true,
      width: '25%',
      name: _i18n.i18n.translate('xpack.fleet.dataStreamList.datasetColumnTitle', {
        defaultMessage: 'Dataset'
      })
    }, {
      field: 'type',
      sortable: true,
      name: _i18n.i18n.translate('xpack.fleet.dataStreamList.typeColumnTitle', {
        defaultMessage: 'Type'
      })
    }, {
      field: 'namespace',
      sortable: true,
      name: _i18n.i18n.translate('xpack.fleet.dataStreamList.namespaceColumnTitle', {
        defaultMessage: 'Namespace'
      }),
      render: namespace => {
        return namespace ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: "hollow",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 62,
            columnNumber: 30
          }
        }, namespace) : '';
      }
    }, {
      field: 'package',
      sortable: true,
      name: _i18n.i18n.translate('xpack.fleet.dataStreamList.integrationColumnTitle', {
        defaultMessage: 'Integration'
      }),
      render(pkg, datastream) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "s",
          alignItems: "center",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 73,
            columnNumber: 13
          }
        }, datastream.package_version && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 75,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_components.PackageIcon, {
          packageName: pkg,
          version: datastream.package_version,
          size: "m",
          tryApi: true,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 76,
            columnNumber: 19
          }
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 84,
            columnNumber: 15
          }
        }, pkg));
      }
    }, {
      field: 'last_activity_ms',
      sortable: true,
      width: '25%',
      dataType: 'date',
      name: _i18n.i18n.translate('xpack.fleet.dataStreamList.lastActivityColumnTitle', {
        defaultMessage: 'Last activity'
      }),
      render: date => {
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedDate, {
          value: date,
          year: "numeric",
          month: "short",
          day: "numeric",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 100,
            columnNumber: 15
          }
        }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, " @ "), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedTime, {
          value: date,
          hour: "numeric",
          minute: "numeric",
          second: "numeric",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 102,
            columnNumber: 15
          }
        }));
      }
    }, {
      field: 'size_in_bytes',
      sortable: true,
      name: _i18n.i18n.translate('xpack.fleet.dataStreamList.sizeColumnTitle', {
        defaultMessage: 'Size'
      }),
      render: (_, datastream) => {
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, datastream.size_in_bytes_formatted);
      }
    }, {
      name: _i18n.i18n.translate('xpack.fleet.dataStreamList.actionsColumnTitle', {
        defaultMessage: 'Actions'
      }),
      actions: [{
        render: datastream => /*#__PURE__*/_react.default.createElement(_data_stream_row_actions.DataStreamRowActions, {
          datastream: datastream,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 123,
            columnNumber: 49
          }
        })
      }]
    }];
    return cols;
  }, []);
  const emptyPrompt = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.dataStreamList.noDataStreamsPrompt",
      defaultMessage: "No data streams",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 13
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 7
    }
  }), []);
  const filterOptions = {
    dataset: [],
    type: [],
    namespace: [],
    package: []
  };
  if (dataStreamsData && dataStreamsData.data_streams.length) {
    const dataValues = {
      dataset: [],
      type: [],
      namespace: [],
      package: []
    };
    dataStreamsData.data_streams.forEach(stream => {
      const {
        dataset,
        type,
        namespace,
        package: pkg
      } = stream;
      if (!dataValues.dataset.includes(dataset)) {
        dataValues.dataset.push(dataset);
      }
      if (!dataValues.type.includes(type)) {
        dataValues.type.push(type);
      }
      if (!dataValues.namespace.includes(namespace)) {
        dataValues.namespace.push(namespace);
      }
      if (!dataValues.package.includes(pkg)) {
        dataValues.package.push(pkg);
      }
    });
    for (const field in dataValues) {
      if (filterOptions[field]) {
        filterOptions[field] = dataValues[field].sort().map(option => ({
          value: option,
          name: option
        }));
      }
    }
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    loading: isLoading,
    tableLayout: "auto",
    message: isLoading ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.dataStreamList.loadingDataStreamsMessage",
      defaultMessage: "Loading data streams\u2026",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 199,
        columnNumber: 11
      }
    }) : dataStreamsData && !dataStreamsData.data_streams.length ? emptyPrompt : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.dataStreamList.noFilteredDataStreamsMessage",
      defaultMessage: "No matching data streams found",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 206,
        columnNumber: 11
      }
    }),
    items: dataStreamsData ? dataStreamsData.data_streams : [],
    itemId: "index",
    columns: columns,
    pagination: {
      initialPageSize: pagination.pageSize,
      pageSizeOptions
    },
    sorting: true,
    search: {
      toolsRight: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        key: "reloadButton",
        color: "primary",
        iconType: "refresh",
        onClick: () => resendRequest(),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 222,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.dataStreamList.reloadDataStreamsButtonText",
        defaultMessage: "Reload",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 228,
          columnNumber: 13
        }
      }))],
      box: {
        placeholder: _i18n.i18n.translate('xpack.fleet.dataStreamList.searchPlaceholderTitle', {
          defaultMessage: 'Filter data streams'
        }),
        incremental: true
      },
      filters: [{
        type: 'field_value_selection',
        field: 'dataset',
        name: _i18n.i18n.translate('xpack.fleet.dataStreamList.datasetColumnTitle', {
          defaultMessage: 'Dataset'
        }),
        multiSelect: 'or',
        operator: 'exact',
        options: filterOptions.dataset
      }, {
        type: 'field_value_selection',
        field: 'type',
        name: _i18n.i18n.translate('xpack.fleet.dataStreamList.typeColumnTitle', {
          defaultMessage: 'Type'
        }),
        multiSelect: 'or',
        operator: 'exact',
        options: filterOptions.type
      }, {
        type: 'field_value_selection',
        field: 'namespace',
        name: _i18n.i18n.translate('xpack.fleet.dataStreamList.namespaceColumnTitle', {
          defaultMessage: 'Namespace'
        }),
        multiSelect: 'or',
        operator: 'exact',
        options: filterOptions.namespace
      }, {
        type: 'field_value_selection',
        field: 'package',
        name: _i18n.i18n.translate('xpack.fleet.dataStreamList.integrationColumnTitle', {
          defaultMessage: 'Integration'
        }),
        multiSelect: 'or',
        operator: 'exact',
        options: filterOptions.package
      }]
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 5
    }
  });
};
exports.DataStreamListPage = DataStreamListPage;