"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentPolicyOutputsSummary = void 0;
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/agent_list_page/components/agent_policy_outputs_summary.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TruncatedEuiLink = (0, _styledComponents.default)(_eui.EuiLink)`
  overflow: hidden;
  text-overflow: ellipsis;
  white-space: nowrap;
  width: 120px;
`;
const AgentPolicyOutputsSummary = ({
  outputs,
  isMonitoring
}) => {
  var _monitoring$output$id, _monitoring$output, _data$output$id, _data$output;
  const {
    getHref
  } = (0, _hooks.useLink)();
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const closePopover = () => setIsPopoverOpen(false);
  const monitoring = outputs === null || outputs === void 0 ? void 0 : outputs.monitoring;
  const data = outputs === null || outputs === void 0 ? void 0 : outputs.data;
  const listItems = (0, _react.useMemo)(() => {
    if (!(data !== null && data !== void 0 && data.integrations)) return [];
    return ((data === null || data === void 0 ? void 0 : data.integrations) || []).map((integration, index) => {
      var _integration$id;
      return {
        'data-test-subj': `output-integration-${index}`,
        label: `${integration.integrationPolicyName}: ${integration.name}`,
        href: getHref('settings_edit_outputs', {
          outputId: (_integration$id = integration === null || integration === void 0 ? void 0 : integration.id) !== null && _integration$id !== void 0 ? _integration$id : ''
        }),
        iconType: 'dot'
      };
    });
  }, [getHref, data === null || data === void 0 ? void 0 : data.integrations]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "baseline",
    responsive: false,
    justifyContent: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  }, isMonitoring ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(TruncatedEuiLink, {
    href: getHref('settings_edit_outputs', {
      outputId: (_monitoring$output$id = monitoring === null || monitoring === void 0 ? void 0 : (_monitoring$output = monitoring.output) === null || _monitoring$output === void 0 ? void 0 : _monitoring$output.id) !== null && _monitoring$output$id !== void 0 ? _monitoring$output$id : ''
    }),
    title: monitoring === null || monitoring === void 0 ? void 0 : monitoring.output.name,
    "data-test-subj": "outputNameLink",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 11
    }
  }, monitoring === null || monitoring === void 0 ? void 0 : monitoring.output.name)) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(TruncatedEuiLink, {
    href: getHref('settings_edit_outputs', {
      outputId: (_data$output$id = data === null || data === void 0 ? void 0 : (_data$output = data.output) === null || _data$output === void 0 ? void 0 : _data$output.id) !== null && _data$output$id !== void 0 ? _data$output$id : ''
    }),
    title: data === null || data === void 0 ? void 0 : data.output.name,
    "data-test-subj": "outputNameLink",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 11
    }
  }, data === null || data === void 0 ? void 0 : data.output.name)), (data === null || data === void 0 ? void 0 : data.integrations) && (data === null || data === void 0 ? void 0 : data.integrations.length) >= 1 && !isMonitoring && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    "data-test-subj": "outputsIntegrationsNumberBadge",
    onClick: () => setIsPopoverOpen(!isPopoverOpen),
    onClickAriaLabel: "Open output integrations popover",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 11
    }
  }, "+", data === null || data === void 0 ? void 0 : data.integrations.length), /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    "data-test-subj": "outputPopover",
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    anchorPosition: "downCenter",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.fleet.AgentPolicyOutputsSummary.popover.title', {
    defaultMessage: 'Output for integrations'
  })), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '280px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    listItems: listItems,
    color: "primary",
    size: "s",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 15
    }
  })))));
};
exports.AgentPolicyOutputsSummary = AgentPolicyOutputsSummary;