"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentPolicyAdvancedOptionsContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _missing_privileges_tooltip = require("../../../../../../components/missing_privileges_tooltip");
var _constants = require("../../../../../../../common/constants");
var _hooks = require("../../../../hooks");
var _components = require("../../../../components");
var _components2 = require("../../../../../../components");
var _agent_policy_form = require("../agent_policy_form");
var _services = require("../../../../../../../common/services");
var _hooks2 = require("./hooks");
var _custom_fields = require("./custom_fields");
var _space_selector = require("./space_selector");
var _advanced_monitoring = require("./advanced_monitoring");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/components/agent_policy_advanced_fields/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AgentPolicyAdvancedOptionsContent = ({
  agentPolicy,
  updateAgentPolicy,
  validation,
  disabled = false
}) => {
  var _config$developer$max, _config$developer, _agentPoliciesData$to, _agentPolicy$agent_fe;
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  const {
    spaceId,
    isSpaceAwarenessEnabled
  } = (0, _hooks.useFleetStatus)();
  const {
    getAbsolutePath
  } = (0, _hooks.useLink)();
  const AgentTamperProtectionWrapper = (0, _hooks.useUIExtension)('endpoint', 'endpoint-agent-tamper-protection');
  const config = (0, _hooks.useConfig)();
  const authz = (0, _hooks.useAuthz)();
  const maxAgentPoliciesWithInactivityTimeout = (_config$developer$max = (_config$developer = config.developer) === null || _config$developer === void 0 ? void 0 : _config$developer.maxAgentPoliciesWithInactivityTimeout) !== null && _config$developer$max !== void 0 ? _config$developer$max : _constants.DEFAULT_MAX_AGENT_POLICIES_WITH_INACTIVITY_TIMEOUT;
  const [touchedFields, setTouchedFields] = (0, _react.useState)({});
  const {
    dataOutputOptions,
    dataOutputValueOfSelected,
    monitoringOutputOptions,
    isLoading: isLoadingOptions
  } = (0, _hooks2.useOutputOptions)(agentPolicy);
  const {
    data: agentPoliciesData
  } = (0, _hooks.useGetAgentPolicies)({
    page: 1,
    perPage: 0,
    kuery: `${_constants.LEGACY_AGENT_POLICY_SAVED_OBJECT_TYPE}.inactivity_timeout:*`
  });
  const totalAgentPoliciesWithInactivityTimeout = (_agentPoliciesData$to = agentPoliciesData === null || agentPoliciesData === void 0 ? void 0 : agentPoliciesData.total) !== null && _agentPoliciesData$to !== void 0 ? _agentPoliciesData$to : 0;
  const tooManyAgentPoliciesForInactivityTimeout = maxAgentPoliciesWithInactivityTimeout !== undefined && totalAgentPoliciesWithInactivityTimeout > (maxAgentPoliciesWithInactivityTimeout !== null && maxAgentPoliciesWithInactivityTimeout !== void 0 ? maxAgentPoliciesWithInactivityTimeout : 0);
  const {
    dataDownloadSourceOptions,
    isLoading: isLoadingDownloadSources
  } = (0, _hooks2.useDownloadSourcesOptions)();
  const {
    fleetServerHostsOptions,
    isLoading: isLoadingFleetServerHostsOption
  } = (0, _hooks2.useFleetServerHostsOptions)(agentPolicy);

  // agent monitoring checkbox group can appear multiple times in the DOM, ids have to be unique to work correctly
  const monitoringCheckboxIdSuffix = Date.now();
  const licenseService = (0, _hooks.useLicense)();
  const [isUninstallCommandFlyoutOpen, setIsUninstallCommandFlyoutOpen] = (0, _react.useState)(false);
  const policyHasElasticDefend = (0, _react.useMemo)(() => (0, _services.policyHasEndpointSecurity)(agentPolicy), [agentPolicy]);
  const isManagedPolicy = agentPolicy.is_managed === true;
  const isManagedOrAgentlessPolicy = isManagedPolicy || (agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.supports_agentless) === true;
  const userHasAccessToAllPolicySpaces = (0, _react.useMemo)(() => {
    var _agentPolicy$space_id;
    return 'space_ids' in agentPolicy ? !((_agentPolicy$space_id = agentPolicy.space_ids) !== null && _agentPolicy$space_id !== void 0 && _agentPolicy$space_id.includes(_constants.UNKNOWN_SPACE)) : true;
  }, [agentPolicy]);
  const agentPolicyFormContext = (0, _agent_policy_form.useAgentPolicyFormContext)();
  const AgentTamperProtectionSectionContent = (0, _react.useMemo)(() => {
    var _agentPolicy$is_prote;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
      fullWidth: true,
      title: /*#__PURE__*/_react.default.createElement("h3", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 142,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentPolicyForm.tamperingLabel",
        defaultMessage: "Agent tamper protection",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 143,
          columnNumber: 13
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentPolicyForm.tamperingDescription",
        defaultMessage: "Prevent agents from being uninstalled locally. When enabled, agents can only be uninstalled using an authorization token in the uninstall command. Click { linkName } for the full command.",
        values: {
          linkName: /*#__PURE__*/_react.default.createElement("strong", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 153,
              columnNumber: 33
            }
          }, "Get uninstall command")
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 150,
          columnNumber: 11
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentPolicyForm.tamperingSwitchLabel",
        defaultMessage: "Prevent agent tampering",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 161,
          columnNumber: 15
        }
      }), ' ', !policyHasElasticDefend && /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "tamperMissingIntegrationTooltip",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 166,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        type: "info",
        color: "subdued",
        content: _i18n.i18n.translate('xpack.fleet.agentPolicyForm.tamperingSwitchLabel.disabledWarning', {
          defaultMessage: 'Elastic Defend integration is required to enable this feature'
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 167,
          columnNumber: 19
        }
      }))),
      checked: (_agentPolicy$is_prote = agentPolicy.is_protected) !== null && _agentPolicy$is_prote !== void 0 ? _agentPolicy$is_prote : false,
      onChange: e => {
        updateAgentPolicy({
          is_protected: e.target.checked
        });
      },
      disabled: disabled || !policyHasElasticDefend,
      "data-test-subj": "tamperProtectionSwitch",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 9
      }
    }), agentPolicy.id && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 191,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_missing_privileges_tooltip.MissingPrivilegesToolTip, {
      missingPrivilege: policyHasElasticDefend && agentPolicy.is_protected && !authz.fleet.allAgents ? 'Agents All' : undefined,
      position: "left",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 192,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: () => {
        setIsUninstallCommandFlyoutOpen(true);
      },
      disabled: !agentPolicy.is_protected || !policyHasElasticDefend || !authz.fleet.allAgents,
      "data-test-subj": "uninstallCommandLink",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 200,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.fleet.agentPolicyForm.tamperingUninstallLink', {
      defaultMessage: 'Get uninstall command'
    })))));
  }, [agentPolicy.id, agentPolicy.is_protected, policyHasElasticDefend, updateAgentPolicy, disabled, authz.fleet.allAgents]);
  const AgentTamperProtectionSection = (0, _react.useMemo)(() => {
    if (licenseService.isPlatinum() && !agentPolicy.is_managed && !agentPolicy.supports_agentless) {
      if (AgentTamperProtectionWrapper) {
        return /*#__PURE__*/_react.default.createElement(_react.Suspense, {
          fallback: null,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 232,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(AgentTamperProtectionWrapper.Component, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 233,
            columnNumber: 13
          }
        }, AgentTamperProtectionSectionContent));
      }
      return AgentTamperProtectionSectionContent;
    }
  }, [licenseService, agentPolicy.is_managed, AgentTamperProtectionWrapper, AgentTamperProtectionSectionContent, agentPolicy.supports_agentless]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 254,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.descriptionFieldLabel",
      defaultMessage: "Description",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 255,
        columnNumber: 13
      }
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.descriptionDescription",
      defaultMessage: "Add a description of how this policy will be used.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 262,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 7
    }
  }, isUninstallCommandFlyoutOpen && agentPolicy.id && /*#__PURE__*/_react.default.createElement(_components2.UninstallCommandFlyout, {
    target: "agent",
    policyId: agentPolicy.id,
    onClose: () => setIsUninstallCommandFlyoutOpen(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 269,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    key: "description",
    error: touchedFields.description && validation.description ? validation.description : null,
    isDisabled: disabled,
    isInvalid: Boolean(touchedFields.description && validation.description),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    disabled: disabled || agentPolicy.is_managed === true,
    fullWidth: true,
    value: agentPolicy.description,
    onChange: e => updateAgentPolicy({
      description: e.target.value
    }),
    isInvalid: Boolean(touchedFields.description && validation.description),
    onBlur: () => setTouchedFields({
      ...touchedFields,
      description: true
    }),
    placeholder: _i18n.i18n.translate('xpack.fleet.agentPolicyForm.descriptionFieldPlaceholder', {
      defaultMessage: 'Optional description'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 284,
      columnNumber: 11
    }
  }))), isSpaceAwarenessEnabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 301,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.spaceFieldLabel",
      defaultMessage: "Spaces",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 302,
        columnNumber: 15
      }
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.spaceDescription",
      defaultMessage: "Select one or more spaces for this policy or create a new one. {link}{tooltip}",
      values: {
        link: userHasAccessToAllPolicySpaces && /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          target: "_blank",
          href: getAbsolutePath('/app/management/kibana/spaces/create'),
          external: true,
          "data-test-subj": "spaceSelectorInputLink",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 314,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.agentPolicyForm.createSpaceLink",
          defaultMessage: "Create space",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 320,
            columnNumber: 21
          }
        })),
        tooltip: !userHasAccessToAllPolicySpaces && /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
          type: "info",
          color: "subdued",
          content: _i18n.i18n.translate('xpack.fleet.agentPolicyForm.spaceTooltip', {
            defaultMessage: 'Access to all policy spaces is required for edit.'
          }),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 327,
            columnNumber: 19
          }
        })
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 309,
        columnNumber: 13
      }
    }),
    "data-test-subj": "spaceSelectorInput",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 298,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_space_selector.SpaceSelector, {
    isDisabled: disabled || agentPolicy.is_managed === true || !userHasAccessToAllPolicySpaces,
    value: 'space_ids' in agentPolicy && agentPolicy.space_ids ? agentPolicy.space_ids.filter(id => id !== _constants.UNKNOWN_SPACE) : [spaceId || 'default'],
    setInvalidSpaceError: agentPolicyFormContext === null || agentPolicyFormContext === void 0 ? void 0 : agentPolicyFormContext.setInvalidSpaceError,
    onChange: newValue => {
      if (newValue.length === 0) {
        return;
      }
      updateAgentPolicy({
        space_ids: newValue
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 340,
      columnNumber: 11
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h3", {
      "data-test-subj": "defaultNamespaceHeader",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 364,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.namespaceFieldLabel",
      defaultMessage: "Default namespace",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 365,
        columnNumber: 13
      }
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.namespaceFieldDescription",
      defaultMessage: "Namespaces are a user-configurable arbitrary grouping that makes it easier to search for data and manage user permissions. A policy namespace is used to name its integration's data streams. {fleetUserGuide}.",
      values: {
        fleetUserGuide: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks.links.fleet.datastreamsNamingScheme,
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 377,
            columnNumber: 17
          }
        }, _i18n.i18n.translate('xpack.fleet.agentPolicyForm.nameSpaceFieldDescription.fleetUserGuideLabel', {
          defaultMessage: 'Learn more'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 372,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 361,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: validation.namespace ? validation.namespace : null,
    isInvalid: Boolean(validation.namespace),
    isDisabled: disabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 388,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    singleSelection: true,
    noSuggestions: true,
    isDisabled: disabled,
    selectedOptions: agentPolicy.namespace ? [{
      label: agentPolicy.namespace
    }] : [],
    onCreateOption: value => {
      updateAgentPolicy({
        namespace: value
      });
    },
    onChange: selectedOptions => {
      updateAgentPolicy({
        namespace: selectedOptions.length ? selectedOptions[0] : ''
      });
    },
    isInvalid: Boolean(validation.namespace),
    onBlur: () => setTouchedFields({
      ...touchedFields,
      namespace: true
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 394,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_custom_fields.CustomFields, {
    updateAgentPolicy: updateAgentPolicy,
    agentPolicy: agentPolicy,
    isDisabled: disabled || agentPolicy.is_managed === true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 413,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 421,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.monitoringLabel",
      defaultMessage: "Agent monitoring",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 422,
        columnNumber: 13
      }
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.monitoringDescription",
      defaultMessage: "Collecting monitoring logs and metrics will also create an {agent} integration. Monitoring data will be written to the default namespace specified above.",
      values: {
        agent: /*#__PURE__*/_react.default.createElement(_components.AgentPolicyPackageBadge, {
          pkgName: 'elastic_agent',
          pkgTitle: 'Elastic Agent',
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 434,
            columnNumber: 17
          }
        })
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 429,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 418,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 440,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckboxGroup, {
    disabled: disabled || isManagedOrAgentlessPolicy,
    options: [{
      id: `${_constants.dataTypes.Logs}_${monitoringCheckboxIdSuffix}`,
      'data-test-subj': 'collectLogsCheckbox',
      label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentPolicyForm.monitoringLogsFieldLabel",
        defaultMessage: "Collect agent logs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 449,
          columnNumber: 19
        }
      }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: _i18n.i18n.translate('xpack.fleet.agentPolicyForm.monitoringLogsTooltipText', {
          defaultMessage: 'Collect logs from Elastic Agents that use this policy.'
        }),
        position: "right",
        type: "info",
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 453,
          columnNumber: 19
        }
      }))
    }, {
      id: `${_constants.dataTypes.Metrics}_${monitoringCheckboxIdSuffix}`,
      'data-test-subj': 'collectMetricsCheckbox',
      label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentPolicyForm.monitoringMetricsFieldLabel",
        defaultMessage: "Collect agent metrics",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 472,
          columnNumber: 19
        }
      }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: _i18n.i18n.translate('xpack.fleet.agentPolicyForm.monitoringMetricsTooltipText', {
          defaultMessage: 'Collect metrics from Elastic Agents that use this policy.'
        }),
        position: "right",
        type: "info",
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 476,
          columnNumber: 19
        }
      }))
    }],
    idToSelectedMap: (agentPolicy.monitoring_enabled || []).reduce((acc, key) => {
      acc[`${key}_${monitoringCheckboxIdSuffix}`] = true;
      return acc;
    }, {
      logs: false,
      metrics: false
    }),
    onChange: longId => {
      const id = longId.split('_')[0];
      if (id !== _constants.dataTypes.Logs && id !== _constants.dataTypes.Metrics) {
        return;
      }
      const hasLogs = agentPolicy.monitoring_enabled && agentPolicy.monitoring_enabled.indexOf(id) >= 0;
      const previousValues = agentPolicy.monitoring_enabled || [];
      updateAgentPolicy({
        monitoring_enabled: hasLogs ? previousValues.filter(type => type !== id) : [...previousValues, id]
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 441,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_advanced_monitoring.AgentPolicyAdvancedMonitoringOptions, {
    agentPolicy: agentPolicy,
    disabled: disabled || agentPolicy.is_managed === true,
    validation: validation,
    touchedFields: touchedFields,
    updateTouchedFields: fields => setTouchedFields({
      ...touchedFields,
      ...fields
    }),
    updateAgentPolicy: updateAgentPolicy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 517,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 525,
      columnNumber: 7
    }
  }), AgentTamperProtectionSection, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 532,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.inactivityTimeoutLabel",
      defaultMessage: "Inactivity timeout",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 533,
        columnNumber: 13
      }
    }), tooManyAgentPoliciesForInactivityTimeout && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentPolicyForm.inactivityTimeoutTooltip",
        defaultMessage: "The maximum of 750 agent policies with an inactivity timeout has been exceeded. Remove inactivity timeouts or agent policies to allow agents to become inactive again.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 542,
          columnNumber: 21
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 540,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "warning",
      tabIndex: 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 548,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.inactivityTimeoutBadge",
      defaultMessage: "Warning",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 549,
        columnNumber: 21
      }
    }))))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.inactivityTimeoutDescription",
      defaultMessage: "An optional timeout in seconds. If provided, an agent will automatically change to inactive status and be filtered out of the agents list. A maximum of 750 agent policies can have an inactivity timeout.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 560,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 529,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: touchedFields.inactivity_timeout && validation.inactivity_timeout ? validation.inactivity_timeout : null,
    isInvalid: Boolean(touchedFields.inactivity_timeout && validation.inactivity_timeout),
    isDisabled: disabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 566,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    fullWidth: true,
    disabled: disabled || isManagedOrAgentlessPolicy,
    value: agentPolicy.inactivity_timeout || '',
    min: 0,
    onChange: e => {
      updateAgentPolicy({
        inactivity_timeout: e.target.value ? Number(e.target.value) : 0
      });
    },
    isInvalid: Boolean(touchedFields.inactivity_timeout && validation.inactivity_timeout),
    onBlur: () => setTouchedFields({
      ...touchedFields,
      inactivity_timeout: true
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 576,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 594,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.fleetServerHostsLabel",
      defaultMessage: "Fleet Server",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 595,
        columnNumber: 13
      }
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.fleetServerHostsDescripton",
      defaultMessage: "Select to which Fleet Server the agents in this policy will communicate.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 602,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 591,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: touchedFields.fleet_server_host_id && validation.fleet_server_host_id ? validation.fleet_server_host_id : null,
    isDisabled: disabled,
    isInvalid: Boolean(touchedFields.fleet_server_host_id && validation.fleet_server_host_id),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 608,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    disabled: disabled || isManagedOrAgentlessPolicy,
    valueOfSelected: agentPolicy.fleet_server_host_id || _hooks2.DEFAULT_SELECT_VALUE,
    fullWidth: true,
    isLoading: isLoadingFleetServerHostsOption,
    onChange: e => {
      updateAgentPolicy({
        fleet_server_host_id: e !== _hooks2.DEFAULT_SELECT_VALUE ? e : null
      });
    },
    options: fleetServerHostsOptions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 618,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 635,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.dataOutputLabel",
      defaultMessage: "Output for integrations",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 636,
        columnNumber: 13
      }
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.dataOutputDescription",
      defaultMessage: "Select which output to use for data from integrations.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 643,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 632,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: touchedFields.data_output_id && validation.data_output_id ? validation.data_output_id : null,
    isInvalid: Boolean(touchedFields.data_output_id && validation.data_output_id),
    isDisabled: disabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 649,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    disabled: disabled || isManagedOrAgentlessPolicy,
    valueOfSelected: dataOutputValueOfSelected,
    fullWidth: true,
    isLoading: isLoadingOptions,
    onChange: e => {
      updateAgentPolicy({
        data_output_id: e !== _hooks2.DEFAULT_SELECT_VALUE ? e : null
      });
    },
    options: dataOutputOptions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 659,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 676,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.monitoringOutputLabel",
      defaultMessage: "Output for agent monitoring",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 677,
        columnNumber: 13
      }
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.monitoringOutputDescription",
      defaultMessage: "Select which output to use for the agents own monitoring data.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 684,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 673,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: touchedFields.monitoring_output_id && validation.monitoring_output_id ? validation.monitoring_output_id : null,
    isInvalid: Boolean(touchedFields.monitoring_output_id && validation.monitoring_output_id),
    isDisabled: disabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 690,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    disabled: disabled || isManagedOrAgentlessPolicy,
    valueOfSelected: agentPolicy.monitoring_output_id || _hooks2.DEFAULT_SELECT_VALUE,
    fullWidth: true,
    isLoading: isLoadingOptions,
    onChange: e => {
      updateAgentPolicy({
        monitoring_output_id: e !== _hooks2.DEFAULT_SELECT_VALUE ? e : null
      });
    },
    options: monitoringOutputOptions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 700,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 717,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.downloadSourceLabel",
      defaultMessage: "Agent binary download",
      "data-test-subj": "agentPolicyForm.downloadSource.label",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 718,
        columnNumber: 13
      }
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.downloadSourceDescription",
      defaultMessage: "When an upgrade action is issued the agents will download the binary from this location.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 726,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 714,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: touchedFields.download_source_id && validation.download_source_id ? validation.download_source_id : null,
    isInvalid: Boolean(touchedFields.download_source_id && validation.download_source_id),
    isDisabled: disabled || isManagedOrAgentlessPolicy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 732,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    disabled: disabled || isManagedOrAgentlessPolicy,
    valueOfSelected: agentPolicy.download_source_id || _hooks2.DEFAULT_SELECT_VALUE,
    fullWidth: true,
    isLoading: isLoadingDownloadSources,
    onChange: e => {
      updateAgentPolicy({
        download_source_id: e !== _hooks2.DEFAULT_SELECT_VALUE ? e : null
      });
    },
    options: dataDownloadSourceOptions,
    "data-test-subj": "agentPolicyForm.downloadSource.select",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 742,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 760,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.hostnameFormatLabel",
      defaultMessage: "Host name format",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 761,
        columnNumber: 13
      }
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.hostnameFormatLabelDescription",
      defaultMessage: "Select how you would like agent domain names to be displayed.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 768,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 757,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    isDisabled: disabled || isManagedOrAgentlessPolicy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 774,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    disabled: disabled || isManagedOrAgentlessPolicy,
    options: [{
      id: 'hostname',
      label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs",
        direction: "column",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 782,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 783,
          columnNumber: 23
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 784,
          columnNumber: 25
        }
      }, /*#__PURE__*/_react.default.createElement("b", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 785,
          columnNumber: 27
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentPolicyForm.hostnameFormatOptionHostname",
        defaultMessage: "Hostname",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 786,
          columnNumber: 29
        }
      })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 793,
          columnNumber: 23
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 794,
          columnNumber: 25
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentPolicyForm.hostnameFormatOptionHostnameExample",
        defaultMessage: "ex: My-Laptop",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 795,
          columnNumber: 27
        }
      })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 802,
          columnNumber: 21
        }
      }))
    }, {
      id: 'fqdn',
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs",
        direction: "column",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 809,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 810,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 811,
          columnNumber: 23
        }
      }, /*#__PURE__*/_react.default.createElement("b", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 812,
          columnNumber: 25
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentPolicyForm.hostnameFormatOptionFqdn",
        defaultMessage: "Fully Qualified Domain Name (FQDN)",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 813,
          columnNumber: 27
        }
      })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 820,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 821,
          columnNumber: 23
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentPolicyForm.hostnameFormatOptionFqdnExample",
        defaultMessage: "ex: My-Laptop.admin.acme.co",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 822,
          columnNumber: 25
        }
      }))))
    }],
    idSelected: (_agentPolicy$agent_fe = agentPolicy.agent_features) !== null && _agentPolicy$agent_fe !== void 0 && _agentPolicy$agent_fe.length ? 'fqdn' : 'hostname',
    onChange: id => {
      updateAgentPolicy({
        agent_features: id === 'hostname' ? [] : [{
          name: 'fqdn',
          enabled: true
        }]
      });
    },
    name: "hostNameFormat",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 775,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 845,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.unenrollmentTimeoutLabel",
      defaultMessage: "Inactive agent unenrollment timeout",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 846,
        columnNumber: 13
      }
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.unenrollmentTimeoutDescription",
      defaultMessage: "An optional timeout in seconds. If configured, inactive agents will be automatically unenrolled and their API keys will be invalidated after they've been inactive for this value in seconds. This can be useful for policies containing ephemeral agents, such as those in a Docker or Kubernetes environment.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 853,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 842,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: touchedFields.unenroll_timeout && validation.unenroll_timeout ? validation.unenroll_timeout : null,
    isInvalid: Boolean(touchedFields.unenroll_timeout && validation.unenroll_timeout),
    isDisabled: disabled || isManagedOrAgentlessPolicy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 859,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    fullWidth: true,
    disabled: disabled || isManagedOrAgentlessPolicy,
    value: agentPolicy.unenroll_timeout || '',
    min: 0,
    onChange: e => {
      updateAgentPolicy({
        unenroll_timeout: e.target.value ? Number(e.target.value) : 0
      });
    },
    isInvalid: Boolean(touchedFields.unenroll_timeout && validation.unenroll_timeout),
    onBlur: () => setTouchedFields({
      ...touchedFields,
      unenroll_timeout: true
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 869,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 884,
      columnNumber: 7
    }
  }));
};
exports.AgentPolicyAdvancedOptionsContent = AgentPolicyAdvancedOptionsContent;