"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataTypesSelect = DataTypesSelect;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_series_storage = require("../../hooks/use_series_storage");
var _exploratory_view_config = require("../../contexts/exploratory_view_config");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/exploratory_view/public/components/shared/exploratory_view/series_editor/columns/data_type_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SELECT_DATA_TYPE = 'SELECT_DATA_TYPE';
function DataTypesSelect({
  seriesId,
  series
}) {
  const {
    setSeries,
    reportType
  } = (0, _use_series_storage.useSeriesStorage)();
  const [showOptions, setShowOptions] = (0, _react.useState)(false);
  const focusButton = (0, _react.useCallback)(ref => {
    ref === null || ref === void 0 ? void 0 : ref.focus();
  }, []);
  const onDataTypeChange = dataType => {
    if (String(dataType) !== SELECT_DATA_TYPE) {
      setSeries(seriesId, {
        dataType,
        time: series.time,
        name: `${dataType}-series-${seriesId + 1}`
      });
    }
  };
  const {
    dataTypes,
    reportConfigMap
  } = (0, _exploratory_view_config.useExploratoryView)();
  const options = dataTypes.filter(({
    id
  }) => {
    var _reportConfigMap$id;
    return (_reportConfigMap$id = reportConfigMap[id]) === null || _reportConfigMap$id === void 0 ? void 0 : _reportConfigMap$id.find(config => config({}).reportType === reportType);
  }).map(({
    id,
    label
  }) => ({
    value: id,
    inputDisplay: label
  }));
  const currDataType = dataTypes.find(dt => dt.id === series.dataType);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !series.dataType && /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "o11yDataTypesSelectButton",
      iconType: "plusInCircle",
      onClick: () => setShowOptions(prevState => !prevState),
      fill: true,
      size: "s",
      buttonRef: focusButton,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 13
      }
    }, SELECT_DATA_TYPE_LABEL),
    isOpen: showOptions,
    closePopover: () => setShowOptions(prevState => !prevState),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 11
    }
  }, options.map(option => /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    key: option.value,
    onClick: () => onDataTypeChange(option.value),
    label: option.inputDisplay,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 15
    }
  })))), series.dataType && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: SELECT_DATA_TYPE_TOOLTIP,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    tabIndex: 0,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 11
    }
  }, currDataType === null || currDataType === void 0 ? void 0 : currDataType.label)));
}
const SELECT_DATA_TYPE_LABEL = _i18n.i18n.translate('xpack.exploratoryView.selectDataType', {
  defaultMessage: 'Select data type'
});
const SELECT_DATA_TYPE_TOOLTIP = _i18n.i18n.translate('xpack.exploratoryView.selectDataTypeTooltip', {
  defaultMessage: 'Data type cannot be edited.'
});