"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerConfigDataRoute = registerConfigDataRoute;
var _repoInfo = require("@kbn/repo-info");
var _agentless = require("../../utils/agentless");
var _elasticsearch_error_handler = require("../../utils/elasticsearch_error_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerConfigDataRoute({
  router,
  config,
  log,
  globalConfigService,
  getStartServices
}) {
  router.get({
    path: '/internal/enterprise_search/config_data',
    security: {
      authz: {
        enabled: false,
        reason: 'This route delegates authorization to the scoped ES client'
      }
    },
    validate: false
  }, (0, _elasticsearch_error_handler.elasticsearchErrorHandler)(log, async (context, _request, response) => {
    const [_core, start] = await getStartServices();
    const data = {
      features: {
        hasConnectors: config.hasConnectors,
        hasDefaultIngestPipeline: config.hasDefaultIngestPipeline,
        hasDocumentLevelSecurityEnabled: config.hasDocumentLevelSecurityEnabled,
        hasIncrementalSyncEnabled: config.hasIncrementalSyncEnabled,
        hasNativeConnectors: (0, _agentless.isAgentlessEnabled)(start),
        // 9.x Does not have ent search node, and therefore does not have support for the following
        hasWebCrawler: false
      },
      kibanaVersion: _repoInfo.kibanaPackageJson.version
    };
    return response.ok({
      body: data,
      headers: {
        'content-type': 'application/json'
      }
    });
  }));
  router.get({
    path: '/internal/enterprise_search/es_config',
    security: {
      authz: {
        enabled: false,
        reason: 'This route delegates authorization to the scoped ES client'
      }
    },
    validate: false
  }, (0, _elasticsearch_error_handler.elasticsearchErrorHandler)(log, async (context, request, response) => {
    return response.ok({
      body: {
        elasticsearch_host: globalConfigService.elasticsearchUrl
      },
      headers: {
        'content-type': 'application/json'
      }
    });
  }));
}