"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createGetDocViewer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/unified-doc-viewer-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/context_awareness/profile_providers/observability/observability_document_profile/document_profile/accessors/doc_viewer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const createGetDocViewer = indexes => prev => params => {
  const prevDocViewer = prev(params);
  const tabTitle = _i18n.i18n.translate('discover.docViews.observability.generic.overview.title', {
    defaultMessage: 'Overview'
  });
  return {
    ...prevDocViewer,
    docViewsRegistry: registry => {
      registry.add({
        id: 'doc_view_obs_generic_overview',
        title: tabTitle,
        order: 0,
        component: props => /*#__PURE__*/_react.default.createElement(_public.UnifiedDocViewerObservabilityGenericOverview, (0, _extends2.default)({}, props, {
          indexes: indexes,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 34,
            columnNumber: 13
          }
        }))
      });
      return prevDocViewer.docViewsRegistry(registry);
    }
  };
};
exports.createGetDocViewer = createGetDocViewer;