"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContextErrorMessage = ContextErrorMessage;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _context_query_state = require("../../services/context_query_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/application/context/components/context_error_message/context_error_message.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function ContextErrorMessage({
  status
}) {
  if (status.value !== _context_query_state.LoadingStatus.FAILED) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "discover.context.failedToLoadAnchorDocumentDescription",
      defaultMessage: "Failed to load the anchor document",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 30,
        columnNumber: 9
      }
    }),
    color: "danger",
    iconType: "warning",
    "data-test-subj": "contextErrorMessageTitle",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "contextErrorMessageBody",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }, status.reason === _context_query_state.FailureReason.UNKNOWN && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.context.reloadPageDescription.reloadOrVisitTextMessage",
    defaultMessage: "Please reload or go back to the document list to select a valid anchor document.",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 11
    }
  })));
}