"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapPercentageToQuality = void 0;
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mapPercentageToQuality = percentages => {
  if (percentages.some(percentage => percentage > _constants.POOR_QUALITY_MINIMUM_PERCENTAGE)) {
    return 'poor';
  }
  if (percentages.some(percentage => percentage > _constants.DEGRADED_QUALITY_MINIMUM_PERCENTAGE)) {
    return 'degraded';
  }
  return 'good';
};
exports.mapPercentageToQuality = mapPercentageToQuality;