"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColumnChart = void 0;
var _react = _interopRequireDefault(require("react"));
var _charts = require("@elastic/charts");
var _chartsTheme = require("@kbn/charts-theme");
var _mlDataGrid = require("@kbn/ml-data-grid");
var _i18n = require("@kbn/i18n");
var _use_column_chart = require("./use_column_chart");
var _column_chart_styles = require("./column_chart_styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/common/components/stats_table/components/field_data_row/column_chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const zeroSize = {
  bottom: 0,
  left: 0,
  right: 0,
  top: 0
};
const size = {
  width: 100,
  height: 10
};
const ColumnChart = ({
  chartData,
  columnType,
  dataTestSubj,
  hideLabel,
  maxChartColumns,
  isNumeric
}) => {
  const {
    data,
    legendText
  } = (0, _use_column_chart.useColumnChart)(chartData, columnType, maxChartColumns, isNumeric);
  const styles = (0, _column_chart_styles.useColumnChartStyles)();
  const chartBaseTheme = (0, _chartsTheme.useElasticChartsTheme)();
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": dataTestSubj,
    style: {
      width: '100%'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  }, !(0, _mlDataGrid.isUnsupportedChartData)(chartData) && data.length > 0 && /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: size,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    baseTheme: chartBaseTheme,
    xDomain: Array.from({
      length: maxChartColumns
    }, (_, i) => i),
    theme: {
      chartMargins: zeroSize,
      chartPaddings: zeroSize,
      crosshair: {
        band: {
          visible: false
        }
      },
      axes: {
        gridLine: {
          horizontal: {
            visible: false
          },
          vertical: {
            visible: false
          }
        }
      }
    },
    locale: _i18n.i18n.getLocale(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "bottom",
    position: _charts.Position.Bottom,
    tickFormat: idx => {
      var _data$idx$key_as_stri, _data$idx;
      return `${(_data$idx$key_as_stri = (_data$idx = data[idx]) === null || _data$idx === void 0 ? void 0 : _data$idx.key_as_string) !== null && _data$idx$key_as_stri !== void 0 ? _data$idx$key_as_stri : ''}`;
    },
    hide: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: 'count',
    xScaleType: _charts.ScaleType.Ordinal,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "x",
    yAccessors: ['doc_count'],
    data: data,
    styleAccessor: d => d.datum.color,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement("div", {
    css: styles.legend,
    "data-test-subj": `${dataTestSubj}-legend`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }, legendText), !hideLabel && /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `${dataTestSubj}-id`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 22
    }
  }, columnType.id));
};
exports.ColumnChart = ColumnChart;