"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AutoFollowPatternActionMenu = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _auto_follow_pattern_delete_provider = require("../auto_follow_pattern_delete_provider");
var _routing = require("../../services/routing");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/cross_cluster_replication/public/app/components/auto_follow_pattern_action_menu/auto_follow_pattern_action_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// @ts-ignore
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const actionsAriaLabel = _i18n.i18n.translate('xpack.crossClusterReplication.autoFollowActionMenu.autoFollowPatternActionMenuButtonAriaLabel', {
  defaultMessage: 'Auto-follow pattern options'
});
const allValuesSame = values => {
  if (!values.length) {
    return false;
  }
  const [firstValue, ...restValues] = values;
  for (const value of restValues) {
    if (firstValue !== value) {
      return false;
    }
  }
  return true;
};
const AutoFollowPatternActionMenuUI = ({
  patterns,
  deleteAutoFollowPattern,
  pauseAutoFollowPattern,
  resumeAutoFollowPattern,
  arrowDirection,
  edit
}) => {
  const [showPopover, setShowPopover] = (0, _react.useState)(false);
  const allActiveValuesSame = allValuesSame(patterns.filter(Boolean).map(({
    active
  }) => active));
  const closePopoverViaAction = () => {
    setShowPopover(false);
  };
  const panelItems = [
  /**
   * Resume or pause pattern
   */
  allActiveValuesSame ? patterns[0].active ? {
    name: _i18n.i18n.translate('xpack.crossClusterReplication.pauseAutoFollowPatternsLabel', {
      defaultMessage: 'Pause {total, plural, one {replication} other {replications}}',
      values: {
        total: patterns.length
      }
    }),
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "pause",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 19
      }
    }),
    onClick: () => {
      pauseAutoFollowPattern(patterns.map(({
        name
      }) => name));
      closePopoverViaAction();
    }
  } : {
    name: _i18n.i18n.translate('xpack.crossClusterReplication.resumeAutoFollowPatternsLabel', {
      defaultMessage: 'Resume {total, plural, one {replication} other {replications}}',
      values: {
        total: patterns.length
      }
    }),
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "play",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 19
      }
    }),
    onClick: () => {
      resumeAutoFollowPattern(patterns.map(({
        name
      }) => name));
      closePopoverViaAction();
    }
  } : null,
  /**
   * Navigate to edit a pattern
   */
  edit && patterns.length === 1 ? {
    name: _i18n.i18n.translate('xpack.crossClusterReplication.editAutoFollowPatternButtonLabel', {
      defaultMessage: 'Edit pattern'
    }),
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "pencil",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 17
      }
    }),
    onClick: () => {
      _routing.routing.navigate(_routing.routing.getAutoFollowPatternPath(patterns[0].name));
    }
  } : null,
  /**
   * Delete a pattern
   */
  {
    name: _i18n.i18n.translate('xpack.crossClusterReplication.deleteAutoFollowPatternButtonLabel', {
      defaultMessage: 'Delete {total, plural, one {pattern} other {patterns}}',
      values: {
        total: patterns.length
      }
    }),
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "trash",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 13
      }
    }),
    onClick: () => {
      deleteAutoFollowPattern(patterns.map(({
        name
      }) => name));
      closePopoverViaAction();
    }
  }].filter(Boolean);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "autoFollowPatternActionMenuButton",
    "aria-label": actionsAriaLabel,
    onClick: () => setShowPopover(!showPopover),
    iconType: arrowDirection === 'up' ? 'arrowUp' : 'arrowDown',
    iconSide: "right",
    fill: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPatternActionMenu.buttonLabel', {
    defaultMessage: 'Manage {patterns, plural, one {pattern} other {patterns}}',
    values: {
      patterns: patterns.length
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: showPopover,
    closePopover: () => setShowPopover(false),
    button: button,
    panelPaddingSize: "none",
    repositionOnScroll: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    "data-test-subj": "autoFollowPatternActionContextMenu",
    panels: [{
      id: 0,
      title: _i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPatternActionMenu.panelTitle', {
        defaultMessage: 'Pattern options'
      }),
      items: panelItems
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 7
    }
  }));
};
const AutoFollowPatternActionMenu = props => /*#__PURE__*/_react.default.createElement(_auto_follow_pattern_delete_provider.AutoFollowPatternDeleteProvider, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 171,
    columnNumber: 3
  }
}, deleteAutoFollowPattern => /*#__PURE__*/_react.default.createElement(AutoFollowPatternActionMenuUI, (0, _extends2.default)({}, props, {
  deleteAutoFollowPattern: deleteAutoFollowPattern,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 173,
    columnNumber: 7
  }
})));
exports.AutoFollowPatternActionMenu = AutoFollowPatternActionMenu;